/*
 * Decompiled with CFR 0.152.
 */
package readonly.api.versioning.expr;

import java.util.ArrayList;
import java.util.regex.Matcher;
import readonly.api.versioning.ElementStream;
import readonly.api.versioning.Version;
import readonly.api.versioning.expr.Expression;
import readonly.api.versioning.expr.LexerException;
import readonly.api.versioning.expr.Token;

public class Expressions {

    static class Or
    implements Expression {
        private final Expression left;
        private final Expression right;

        Or(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean interpret(Version version) {
            return this.left.interpret(version) || this.right.interpret(version);
        }
    }

    static class NotEqual
    implements Expression {
        private final Version parsedVersion;

        NotEqual(Version parsedVersion) {
            this.parsedVersion = parsedVersion;
        }

        @Override
        public boolean interpret(Version version) {
            return !version.equals(this.parsedVersion);
        }
    }

    static class Not
    implements Expression {
        private final Expression expr;

        Not(Expression expr) {
            this.expr = expr;
        }

        @Override
        public boolean interpret(Version version) {
            return !this.expr.interpret(version);
        }
    }

    static class Lexer {
        Lexer() {
        }

        ElementStream<Token> tokenize(String input) {
            ArrayList<Token> tokens = new ArrayList<Token>();
            int tokenPos = 0;
            while (!input.isEmpty()) {
                boolean matched = false;
                for (Token.Type tokenType : Token.Type.values()) {
                    Matcher matcher = tokenType.pattern.matcher(input);
                    if (!matcher.find()) continue;
                    matched = true;
                    input = matcher.replaceFirst("");
                    if (tokenType != Token.Type.WHITESPACE) {
                        tokens.add(new Token(tokenType, matcher.group(), tokenPos));
                    }
                    tokenPos += matcher.end();
                    break;
                }
                if (matched) continue;
                throw new LexerException(input);
            }
            tokens.add(new Token(Token.Type.EOI, null, tokenPos));
            return new ElementStream<Token>(tokens.toArray(new Token[tokens.size()]));
        }
    }

    static class LessOrEqual
    implements Expression {
        private final Version parsedVersion;

        LessOrEqual(Version parsedVersion) {
            this.parsedVersion = parsedVersion;
        }

        @Override
        public boolean interpret(Version version) {
            return version.lessThanOrEqualTo(this.parsedVersion);
        }
    }

    static class Less
    implements Expression {
        private final Version parsedVersion;

        Less(Version parsedVersion) {
            this.parsedVersion = parsedVersion;
        }

        @Override
        public boolean interpret(Version version) {
            return version.lessThan(this.parsedVersion);
        }
    }

    static class GreaterOrEqual
    implements Expression {
        private final Version parsedVersion;

        GreaterOrEqual(Version parsedVersion) {
            this.parsedVersion = parsedVersion;
        }

        @Override
        public boolean interpret(Version version) {
            return version.greaterThanOrEqualTo(this.parsedVersion);
        }
    }

    static class Greater
    implements Expression {
        private final Version parsedVersion;

        Greater(Version parsedVersion) {
            this.parsedVersion = parsedVersion;
        }

        @Override
        public boolean interpret(Version version) {
            return version.greaterThan(this.parsedVersion);
        }
    }

    static class Equal
    implements Expression {
        private final Version parsedVersion;

        Equal(Version parsedVersion) {
            this.parsedVersion = parsedVersion;
        }

        @Override
        public boolean interpret(Version version) {
            return version.equals(this.parsedVersion);
        }
    }

    static class And
    implements Expression {
        private final Expression left;
        private final Expression right;

        And(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean interpret(Version version) {
            return this.left.interpret(version) && this.right.interpret(version);
        }
    }
}

