/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.client.gui.element;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import readonly.galactictweaks.core.client.gui.element.GuiElement;

public class CheckBoxElement
extends GuiElement {
    private Runnable callback;
    private int boxWidth;
    private String displayString;
    private boolean isChecked;

    public CheckBoxElement(int xPos, int yPos, String displayString, boolean isChecked) {
        super(xPos, yPos, 0, 0);
        this.displayString = displayString;
        this.isChecked = isChecked;
        this.boxWidth = 11;
        this.height = 11;
        this.width = this.boxWidth + 2 + Minecraft.func_71410_x().field_71466_p.func_78256_a(displayString);
    }

    public CheckBoxElement(int xPos, int yPos, String displayString) {
        this(xPos, yPos, displayString, false);
    }

    public CheckBoxElement(int xPos, int yPos) {
        this(xPos, yPos, "", false);
    }

    public CheckBoxElement(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, "", false);
        this.width = width;
        this.height = height;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.boxWidth && mouseY < this.getY() + this.height;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)BUTTON_TEXTURES, (int)this.getX(), (int)this.getY(), (int)0, (int)46, (int)this.boxWidth, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            }
            if (this.isChecked) {
                this.func_73732_a(this.mc.field_71466_p, "x", this.getX() + this.boxWidth / 2 + 1, this.getY() + 1, 0xE0E0E0);
            }
            this.func_73731_b(this.mc.field_71466_p, this.displayString, this.getX() + this.boxWidth + 2, this.getY() + 2, color);
        }
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void onChange() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public final void setChangeListener(Runnable r) {
        this.callback = r;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.mousePressed(Minecraft.func_71410_x(), mouseX, mouseY)) {
            this.onChange();
            this.playPressSound();
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height) {
            this.setIsChecked(!this.isChecked());
            return true;
        }
        return false;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }
}

