/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.gc;

import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.core.util.list.ImmutableCelestialList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import readonly.galactictweaks.core.GCTLog;

public final class GalaxyCache {
    private Map<String, Integer> celesitalNameToDimensionIdMap = new HashMap<String, Integer>();
    private static GalaxyCache instance;

    public static GalaxyCache cache() {
        if (instance == null) {
            instance = new GalaxyCache();
        }
        return instance;
    }

    private GalaxyCache() {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            GCTLog.error("GalaxyCache MUST be initialized if, and ONLY IF, LoaderState has reached FMLPostInitializationEvent", new Object[0]);
        }
        ImmutableCelestialList planets = GalaxyRegistry.getPlanets();
        GCTLog.info("ImmutableCelestialList<Planet> : {}", planets.size());
        ImmutableCelestialList moons = GalaxyRegistry.getMoons();
        GCTLog.info("ImmutableCelestialList<Moon> : {}", moons.size());
        planets.stream().filter(CelestialBody::isReachable).forEach(p -> this.celesitalNameToDimensionIdMap.put(p.getName(), p.getDimensionID()));
        moons.stream().filter(CelestialBody::isReachable).forEach(p -> this.celesitalNameToDimensionIdMap.put(p.getName(), p.getDimensionID()));
    }

    public int getDimensionIdFromName(String name) {
        return this.celesitalNameToDimensionIdMap.get(name);
    }
}

