/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.gc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialObject;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.core.util.list.CelestialList;
import readonly.api.config.def.ValidDimIDs;
import readonly.galactictweaks.GCTweaks;
import readonly.galactictweaks.core.utils.TextTable;
import readonly.galactictweaks.modules.galacticraft.GalacticraftModuleConfig;

public class IOWriter {
    private final List<Planet> planets = new ArrayList<Planet>();
    private final List<Moon> moons = new ArrayList<Moon>();
    private final TextTable.Column name = new TextTable.Column("Name");
    private final TextTable.Column dimid = new TextTable.Column("DimID");
    private final TextTable.Column owner = new TextTable.Column("Owner");
    private TextTable table = new TextTable(this.name, this.dimid, this.owner);
    private PrintWriter writer;

    public IOWriter() {
        CelestialList allReachable = CelestialList.create();
        GalaxyRegistry.getAllReachableBodies().forEach(c -> {
            if (c instanceof Planet) {
                this.planets.add((Planet)c);
            }
            if (c instanceof Moon) {
                this.moons.add((Moon)c);
            }
            allReachable.add((CelestialObject)c);
        });
        GalacticraftModuleConfig.validSPawnDims = new ValidDimIDs((CelestialList<CelestialBody>)allReachable);
    }

    public void handleFile(String name) {
        File dims = new File(GCTweaks.modFolder, name);
        try {
            if (dims.exists()) {
                dims.delete();
            }
            dims.createNewFile();
            this.writer = new PrintWriter(new FileWriter(dims));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(String string) {
        this.writer.println(string);
    }

    public void nl() {
        this.writer.println("");
    }

    public void spacer() {
        this.writer.println("|--------------------------------");
    }

    public void NOTICE() {
        this.writer.println("### NOTICE ###");
    }

    public void title(String title) {
        this.nl();
        this.nl();
        this.writer.println("| ### " + title + " ###");
        this.writer.println("|");
    }

    public void writePlanets() {
        Collections.reverse(this.planets);
        this.table.clear();
        for (Planet planet : this.planets) {
            this.table.add(planet.getName(), planet.getDimensionID(), planet.getOwnerId());
        }
        this.table.add("                ", "       ", "                        ");
        this.writer.println(this.table.build());
    }

    public void writeMoons() {
        Collections.reverse(this.moons);
        this.table.clear();
        for (Moon moon : this.moons) {
            this.table.add(moon.getName(), moon.getDimensionID(), moon.getOwnerId());
        }
        this.table.add("                ", "       ", "                        ");
        this.writer.println(this.table.build());
    }

    public void flushAndClose() {
        this.writer.flush();
        this.writer.close();
    }
}

