/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.gc;

import asmodeuscore.core.astronomy.BodiesRegistry;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.list.ImmutableCelestialList;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.util.ResourceLocation;
import readonly.galactictweaks.core.utils.Galaxy;

public class PlanetData {
    private final ResourceLocation IMG = new ResourceLocation("galactictweaks", "textures/gui/galaxy/wormhole.png");
    private final ResourceLocation SUN = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/sun.png");
    private BodiesRegistry.Galaxies galaxy = BodiesRegistry.registerGalaxy((String)"wormhole", (ResourceLocation)this.IMG);
    private SolarSystem system = new SolarSystem("secondSystem", this.galaxy.getName()).setMapPosition(new Vector3(0.0, 0.0, 0.0));
    public static Planet FAKE_ASTEROIDS;
    public static Planet FAKE_MARS;

    public PlanetData() {
        Star starSol4 = (Star)new Star("epsystem").setParentSolarSystem(this.system).setTierRequired(-1);
        starSol4.setBodyIcon(this.SUN);
        this.system.setMainStar(starSol4);
        GalaxyRegistry.register((Object)this.system);
    }

    public void create(String id) {
        this.buildFakePlanets();
        switch (id) {
            case "galaxyspace": {
                ImmutableCelestialList<Planet> gsPlanets = Galaxy.getFilteredPlanetList(CelestialBody.filter((String)"galaxyspace"));
                ImmutableCelestialList<Moon> gsMoons = Galaxy.getFilteredMoonList(CelestialBody.filter((String)"galaxyspace"));
                gsPlanets.forEach(p -> {
                    if (p.getParentSolarSystem().equals(GalacticraftCore.solarSystemSol)) {
                        p.setParentSolarSystem(this.system);
                    }
                });
                gsMoons.forEach(m -> {
                    if (m != null && m.getParentPlanet() != null && m.getParentPlanet().getDimensionID() == ConfigManagerMars.dimensionIDMars) {
                        m.setParentPlanet(FAKE_MARS);
                    }
                });
                break;
            }
            case "extraplanets": {
                ImmutableCelestialList<Planet> epPlanets = Galaxy.getFilteredPlanetList(CelestialBody.filter((String)"extraplanets"));
                ImmutableCelestialList<Moon> epMoons = Galaxy.getFilteredMoonList(CelestialBody.filter((String)"extraplanets"));
                epPlanets.forEach(p -> {
                    if (p.getParentSolarSystem().equals(GalacticraftCore.solarSystemSol)) {
                        p.setParentSolarSystem(this.system);
                    }
                });
                epMoons.forEach(m -> {
                    if (m != null && m.getParentPlanet() != null && m.getParentPlanet().getDimensionID() == ConfigManagerMars.dimensionIDMars) {
                        m.setParentPlanet(FAKE_MARS);
                    }
                });
                break;
            }
        }
    }

    private void buildFakePlanets() {
        Planet OVERWORLD = GalacticraftCore.planetOverworld;
        Planet ASTEROIDS = AsteroidsModule.planetAsteroids;
        Planet MARS = MarsModule.planetMars;
        FAKE_ASTEROIDS = new Planet("fake_asteroids").setParentSolarSystem(this.system);
        FAKE_ASTEROIDS.setRelativeDistanceFromCenter(ASTEROIDS.getRelativeDistanceFromCenter());
        FAKE_ASTEROIDS.setRelativeOrbitTime(45.0f);
        FAKE_ASTEROIDS.setPhaseShift(ASTEROIDS.getPhaseShift());
        FAKE_ASTEROIDS.setRelativeSize(1.0f);
        FAKE_ASTEROIDS.setBodyIcon(ASTEROIDS.getBodyIcon());
        FAKE_ASTEROIDS.setUnreachable();
        GalaxyRegistry.register((Object)FAKE_ASTEROIDS);
        Planet FAKE_OVERWORLD = new Planet("fake_overworld").setParentSolarSystem(this.system);
        FAKE_OVERWORLD.setRelativeDistanceFromCenter(OVERWORLD.getRelativeDistanceFromCenter());
        FAKE_OVERWORLD.setPhaseShift(OVERWORLD.getPhaseShift());
        FAKE_OVERWORLD.setRelativeSize(1.0f);
        FAKE_OVERWORLD.setBodyIcon(OVERWORLD.getBodyIcon());
        FAKE_OVERWORLD.atmosphere.composition.addAll(Arrays.asList(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER));
        FAKE_OVERWORLD.setUnreachable();
        GalaxyRegistry.register((Object)FAKE_OVERWORLD);
        FAKE_MARS = new Planet("fake_mars").setParentSolarSystem(this.system);
        FAKE_MARS.setRelativeDistanceFromCenter(MARS.getRelativeDistanceFromCenter());
        FAKE_MARS.setRelativeOrbitTime(MARS.getRelativeOrbitTime());
        FAKE_MARS.setPhaseShift(MARS.getPhaseShift());
        FAKE_MARS.setRelativeSize(1.0f);
        FAKE_MARS.setBodyIcon(MARS.getBodyIcon());
        PlanetData.FAKE_MARS.atmosphere.composition.addAll(Arrays.asList(EnumAtmosphericGas.CO2, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.ARGON));
        FAKE_MARS.setUnreachable();
        GalaxyRegistry.register((Object)FAKE_MARS);
    }
}

