/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.gc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import readonly.galactictweaks.core.GCTLog;

public class Schematics {
    public static ArrayList<SchematicItemWrapper> wrappers = new ArrayList();

    public static void getAllSchematics() {
        SchematicRegistry.schematicItems.forEach(stack -> {
            SchematicItemWrapper wrapper = new SchematicItemWrapper((ItemStack)stack);
            Integer id = null;
            try {
                id = SchematicRegistry.getMatchingRecipeForItemStack((ItemStack)stack).getPageID();
            }
            catch (Exception e) {
                GCTLog.error("Could not get PageID for ItemStack [ {} ]", ItemData.getFor(wrapper).toString());
            }
            if (id != null) {
                wrapper.setPageId(id);
                wrappers.add(wrapper);
            }
        });
    }

    public static void printItemInfoToConsole(@Nonnull SchematicItemWrapper wrapper) {
        List<String> lines = Schematics.getFullItemInfo(wrapper);
        for (String line : lines) {
            GCTLog.info(line, new Object[0]);
        }
    }

    private static List<String> getFullItemInfo(@Nonnull SchematicItemWrapper wrapper) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ItemData.getFor(wrapper).toString());
        return lines;
    }

    public static class ItemData {
        private final String regName;
        private final int id;
        private final int meta;
        private final String displayName;
        private final String pageId;

        public ItemData(String displayName, String regName, int id, int meta, String pageId) {
            this.displayName = displayName;
            this.regName = regName;
            this.id = id;
            this.meta = meta;
            this.pageId = pageId;
        }

        public static ItemData getFor(SchematicItemWrapper wrapper) {
            ItemStack stack = wrapper.getItemStack();
            String registryName = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString();
            String ID = wrapper.getPageId() == null ? "NULL" : String.valueOf(wrapper.getPageId());
            return new ItemData(stack.func_82833_r(), registryName, Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j(), ID);
        }

        public String toString() {
            return String.format("{} ({} - {}:{}) {}", this.displayName, this.regName, this.id, this.meta, this.pageId);
        }
    }

    public static class SchematicItemWrapper {
        private ItemStack itemStack;
        @Nullable
        private Integer pageId;

        public SchematicItemWrapper() {
        }

        public SchematicItemWrapper(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public SchematicItemWrapper(ItemStack itemStack, @Nullable Integer pageId) {
            this.itemStack = itemStack;
            this.pageId = pageId;
        }

        public void setItemStack(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public void setPageId(Integer pageId) {
            this.pageId = pageId;
        }

        public Integer getPageId() {
            return this.pageId;
        }
    }
}

