/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.common.math;

import java.awt.Color;
import java.util.Objects;
import javax.vecmath.Vector4f;
import net.machinemuse.numina.common.base.MuseLogger;
import org.lwjgl.opengl.GL11;

public class Colour {
    public static final Colour LIGHTBLUE = new Colour(0.5, 0.5, 1.0, 1.0);
    public static final Colour BLUE = new Colour(0.0, 0.0, 1.0, 1.0);
    public static final Colour DARKBLUE = new Colour(0.0, 0.0, 0.5, 1.0);
    public static final Colour ORANGE = new Colour(0.9, 0.6, 0.2, 1.0);
    public static final Colour YELLOW = new Colour(0.0, 0.0, 0.5, 1.0);
    public static final Colour WHITE = new Colour(1.0, 1.0, 1.0, 1.0);
    public static final Colour BLACK = new Colour(0.0, 0.0, 0.0, 1.0);
    public static final Colour DARKGREY = new Colour(0.4, 0.4, 0.4, 1.0);
    public static final Colour RED = new Colour(1.0, 0.2, 0.2, 1.0);
    public static final Colour LIGHTGREEN = new Colour(0.5, 1.0, 0.5, 1.0);
    public static final Colour GREEN = new Colour(0.0, 1.0, 0.0, 1.0);
    public static final Colour DARKGREEN = new Colour(0.0, 0.8, 0.2, 1.0);
    public static final Colour PURPLE = new Colour(0.6, 0.1, 0.9, 1.0);
    public final double r;
    public final double g;
    public final double b;
    public final double a;

    public Colour(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Colour(double r, double g, double b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0;
    }

    public Colour(int c) {
        this.a = (double)(c >> 24 & 0xFF) / 255.0;
        this.r = (double)(c >> 16 & 0xFF) / 255.0;
        this.g = (double)(c >> 8 & 0xFF) / 255.0;
        this.b = (double)(c & 0xFF) / 255.0;
    }

    public int getMCColour() {
        int val = 0;
        val |= (int)(this.a * 255.0) << 24;
        val |= (int)(this.r * 255.0) << 16;
        val |= (int)(this.b * 255.0) << 8;
        return val |= (int)(this.g * 255.0);
    }

    public static int getInt(double r, double g, double b, double a) {
        int val = 0;
        val |= (int)(a * 255.0) << 24;
        val |= (int)(r * 255.0) << 16;
        val |= (int)(g * 255.0) << 8;
        return val |= (int)(b * 255.0);
    }

    public static Colour getGreyscale(float value, float alpha) {
        return new Colour(value, value, value, alpha);
    }

    public static void doGLByInt(int c) {
        double a = (float)(c >> 24 & 0xFF) / 255.0f;
        double r = (float)(c >> 16 & 0xFF) / 255.0f;
        double g = (float)(c >> 8 & 0xFF) / 255.0f;
        double b = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4d((double)r, (double)g, (double)b, (double)a);
    }

    public static Colour fromHexString(String hexString) {
        try {
            if (hexString == null || hexString.isEmpty()) {
                return WHITE;
            }
            return new Colour((int)Long.parseLong(hexString, 16));
        }
        catch (Exception e) {
            MuseLogger.logException("Failed to generate colour from Hex: ", e);
            return WHITE;
        }
    }

    public int getInt() {
        int val = 0;
        val |= (int)(this.a * 255.0) << 24;
        val |= (int)(this.r * 255.0) << 16;
        val |= (int)(this.g * 255.0) << 8;
        return val |= (int)(this.b * 255.0);
    }

    public Colour interpolate(Colour target, double d) {
        double complement = 1.0 - d;
        return new Colour(this.r * complement + target.r * d, this.g * complement + target.g * d, this.b * complement + target.b * d, this.a * complement + target.a * d);
    }

    public void doGL() {
        GL11.glColor4d((double)this.r, (double)this.g, (double)this.b, (double)this.a);
    }

    public Colour withAlpha(double newalpha) {
        return new Colour(this.r, this.g, this.b, newalpha);
    }

    public double[] asArray() {
        return new double[]{this.r, this.g, this.b, this.a};
    }

    public String hexColour() {
        return this.hexDigits(this.r) + this.hexDigits(this.g) + this.hexDigits(this.b) + (this.a > 0.0 ? this.hexDigits(this.a) : "");
    }

    public String hexDigits(double x) {
        int y = (int)(x * 255.0);
        String hexDigits = "0123456789ABCDEF";
        return hexDigits.charAt(y / 16) + "" + hexDigits.charAt(y % 16);
    }

    public Color awtColor() {
        return new Color((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    public Vector4f toVector4f() {
        Vector4f colorVec = new Vector4f();
        colorVec.w = (float)this.a;
        colorVec.x = (float)this.r;
        colorVec.y = (float)this.g;
        colorVec.z = (float)this.b;
        return colorVec;
    }

    public String toString() {
        return "Colour{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Colour colour = (Colour)o;
        return Double.compare(colour.r, this.r) == 0 && Double.compare(colour.g, this.g) == 0 && Double.compare(colour.b, this.b) == 0 && Double.compare(colour.a, this.a) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b, this.a);
    }
}

