/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.common.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.machinemuse.numina.common.recipe.JsonToNBTFixed;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class NuminaShapedRecipe
extends ShapedRecipes {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public NuminaShapedRecipe(String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(group, width, height, ingredients, result);
    }

    public static NuminaShapedRecipe deserialize(JsonContext context, JsonObject json) {
        String s = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Map<String, Ingredient> map = NuminaShapedRecipe.deserializeKey(JsonUtils.func_152754_s((JsonObject)json, (String)"key"));
        String[] astring = NuminaShapedRecipe.shrink(NuminaShapedRecipe.patternFromJson(JsonUtils.func_151214_t((JsonObject)json, (String)"pattern")));
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = NuminaShapedRecipe.deserializeIngredients(astring, map, i, j);
        ItemStack itemstack = NuminaShapedRecipe.deserializeItem(JsonUtils.func_152754_s((JsonObject)json, (String)"result"), true);
        return new NuminaShapedRecipe(s, i, j, nonnulllist, itemstack);
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] strings, Map<String, Ingredient> ingredientMap, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(ingredientMap.keySet());
        set.remove(" ");
        for (int i = 0; i < strings.length; ++i) {
            for (int j = 0; j < strings[i].length(); ++j) {
                String s = strings[i].substring(j, j + 1);
                Ingredient ingredient = ingredientMap.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < strings.length; ++i1) {
            String s = strings[i1];
            i = Math.min(i, NuminaShapedRecipe.firstNonSpace(s));
            int j1 = NuminaShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] astring = new String[strings.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = strings[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray p_192407_0_) {
        String[] astring = new String[p_192407_0_.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JsonUtils.func_151206_a((JsonElement)p_192407_0_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject jsonObj) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObj.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), NuminaShapedRecipe.deserializeIngredient((JsonElement)entry.getValue()));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static Ingredient deserializeIngredient(@Nullable JsonElement jsonElement) {
        JsonArray jsonarray;
        if (jsonElement == null || jsonElement.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (jsonElement.isJsonObject()) {
            if (jsonElement.getAsJsonObject().has("item")) {
                return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{NuminaShapedRecipe.deserializeItem(jsonElement.getAsJsonObject(), false)});
            }
            if (jsonElement.getAsJsonObject().has("ore")) {
                return new OreIngredient(JsonUtils.func_151200_h((JsonObject)jsonElement.getAsJsonObject(), (String)"ore"));
            }
        } else if (!jsonElement.isJsonArray()) {
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        if ((jsonarray = jsonElement.getAsJsonArray()).size() == 0) {
            throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
        }
        ItemStack[] aitemstack = new ItemStack[jsonarray.size()];
        for (int i = 0; i < jsonarray.size(); ++i) {
            aitemstack[i] = jsonarray.get(i).getAsJsonObject().has("item") ? NuminaShapedRecipe.deserializeItem(JsonUtils.func_151210_l((JsonElement)jsonarray.get(i), (String)"item"), false) : NuminaShapedRecipe.deserializeItem(JsonUtils.func_151210_l((JsonElement)jsonarray.get(i), (String)"ore"), false);
        }
        return Ingredient.func_193369_a((ItemStack[])aitemstack);
    }

    public static ItemStack deserializeItem(JsonObject jsonObj, boolean useCount) {
        int count;
        int n = count = useCount ? JsonUtils.func_151208_a((JsonObject)jsonObj, (String)"count", (int)1) : 1;
        if (jsonObj.has("item")) {
            String name = JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"item");
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (item == null) {
                throw new JsonSyntaxException("Unknown item '" + name + "'");
            }
            if (item.func_77614_k() && !jsonObj.has("data")) {
                throw new JsonParseException("Missing data for item '" + name + "'");
            }
            if (jsonObj.has("nbt")) {
                try {
                    JsonElement element = jsonObj.get("nbt");
                    NBTTagCompound nbt = element.isJsonObject() ? JsonToNBTFixed.getTagFromJson(GSON.toJson(element)) : JsonToNBTFixed.getTagFromJson(element.getAsString());
                    NBTTagCompound tmp = new NBTTagCompound();
                    if (nbt.func_74764_b("ForgeCaps")) {
                        tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                        nbt.func_82580_o("ForgeCaps");
                    }
                    tmp.func_74782_a("tag", (NBTBase)nbt);
                    tmp.func_74778_a("id", name);
                    tmp.func_74768_a("Count", JsonUtils.func_151208_a((JsonObject)jsonObj, (String)"count", (int)1));
                    tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)jsonObj, (String)"data", (int)0));
                    return new ItemStack(tmp);
                }
                catch (NBTException e) {
                    throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
                }
            }
            if (item.func_77614_k()) {
                int meta = JsonUtils.func_151208_a((JsonObject)jsonObj, (String)"data", (int)0);
                return new ItemStack(item, count, meta);
            }
            return new ItemStack(item, count);
        }
        if (jsonObj.has("ore")) {
            ItemStack itemStack = ItemStack.field_190927_a;
            String name = JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"ore");
            NonNullList itemStackList = OreDictionary.getOres((String)name);
            if (itemStackList.size() <= 0) {
                throw new JsonSyntaxException("no such ore found: " + name);
            }
            itemStack = ((ItemStack)itemStackList.get(0)).func_77946_l();
            itemStack.func_190920_e(count);
            return itemStack;
        }
        throw new JsonSyntaxException("no such or item found");
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77574_d;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.field_77576_b && height >= this.field_77577_c;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.field_77576_b; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.field_77577_c; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting craftingInventory, int startX, int startY, boolean mirror) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                int k = i - startX;
                int l = j - startY;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.field_77576_b && l < this.field_77577_c) {
                    ingredient = mirror ? (Ingredient)this.field_77574_d.get(this.field_77576_b - k - 1 + l * this.field_77576_b) : (Ingredient)this.field_77574_d.get(k + l * this.field_77576_b);
                }
                if (ingredient.apply(craftingInventory.func_70463_b(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public int getRecipeWidth() {
        return this.field_77576_b;
    }

    public int getRecipeHeight() {
        return this.field_77577_c;
    }
}

