/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import gnu.trove.map.hash.TIntIntHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class StringHelper {
    private static final LinkedHashMap<String, Integer> roman_numerals = new LinkedHashMap();

    public static String capitalizeProp(String s) {
        StringBuilder builder = new StringBuilder();
        String[] split = s.split("[\\s_-]+");
        for (int i = 0; i < split.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(StringHelper.capFirst(split[i], true));
        }
        return builder.toString();
    }

    public static String capFirst(String s) {
        return StringHelper.capFirst(s, false);
    }

    public static String capFirst(String s, boolean lowerCaseRest) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (n == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + (lowerCaseRest ? s.substring(1).toLowerCase() : s.substring(1));
    }

    public static String sepWords(String input) {
        StringBuilder builder = new StringBuilder();
        boolean prevWasWhiteSpace = true;
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c) || c == '_') {
                prevWasWhiteSpace = true;
            } else {
                if (Character.isUpperCase(c) && !prevWasWhiteSpace) {
                    builder.append(" ");
                }
                prevWasWhiteSpace = false;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String toRomanNumeral(int num) {
        int i = num;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Integer> entry2 : roman_numerals.entrySet()) {
            int value = entry2.getValue();
            int mathes = i / value;
            for (int j = 0; j < mathes; ++j) {
                builder.append(entry2.getKey());
            }
            i %= value;
        }
        return builder.toString();
    }

    public static ArrayList<String> formatTabsToTableSpaced(ArrayList<String> strings) {
        TIntIntHashMap lens = new TIntIntHashMap(10, 0.5f, 0, 0);
        for (String string : strings) {
            String[] split = string.split("\t");
            for (int i = 0; i < split.length; ++i) {
                int n = split[i].length();
                if (lens.get(i) >= n) continue;
                lens.put(i, n);
            }
        }
        int n = 0;
        for (int i = 0; i < lens.size(); ++i) {
            lens.put(i, n += lens.get(i) + 2);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String string : strings) {
            StringBuilder builder = new StringBuilder();
            String[] split = string.split("\t");
            for (int i = 0; i < split.length; ++i) {
                builder.append(split[i]);
                n = lens.get(i);
                while (builder.length() < n) {
                    builder.append(" ");
                }
            }
            result.add(builder.toString());
        }
        return result;
    }

    public static String niceFormat(double v) {
        String format = v == (double)((int)v) ? String.format(Locale.ENGLISH, "%d", (int)v) : String.format(Locale.ENGLISH, "%.2f", v);
        return format;
    }

    public static String erasePrefix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String formatPercent(double v) {
        return NumberFormat.getPercentInstance(Locale.UK).format(v);
    }

    public static String format(int number) {
        return NumberFormat.getInstance(Locale.UK).format(number);
    }

    public static String format(double number) {
        return NumberFormat.getInstance(Locale.UK).format(number);
    }

    public static String format(float number) {
        return NumberFormat.getInstance(Locale.UK).format(number);
    }

    public static String formatDurationSeconds(@Nonnegative long ticks, boolean incExtras) {
        boolean flag;
        long t = ticks % 20L;
        long s = ticks % 1200L / 20L;
        long m = ticks % 72000L / 1200L;
        long h = ticks % 1728000L / 72000L;
        long d = ticks / 1728000L;
        StringBuilder builder = new StringBuilder();
        boolean bl = flag = d > 0L;
        if (flag) {
            builder.append(d).append("d");
        }
        if (h > 0L || incExtras && (flag |= h > 0L)) {
            builder.append(h).append("h");
        }
        if (m > 0L || incExtras && (flag |= m > 0L)) {
            builder.append(m).append("m");
        }
        if (s > 0L || t > 0L || incExtras) {
            if (t == 0L && !incExtras) {
                builder.append(s).append("s");
            } else {
                builder.append(String.format("%.2f", Float.valueOf((float)s + (float)t / 20.0f))).append("s");
            }
        }
        return builder.toString();
    }

    public static boolean isBlank(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    static {
        roman_numerals.put("M", 1000);
        roman_numerals.put("CM", 900);
        roman_numerals.put("D", 500);
        roman_numerals.put("CD", 400);
        roman_numerals.put("C", 100);
        roman_numerals.put("XC", 90);
        roman_numerals.put("L", 50);
        roman_numerals.put("XL", 40);
        roman_numerals.put("X", 10);
        roman_numerals.put("IX", 9);
        roman_numerals.put("V", 5);
        roman_numerals.put("IV", 4);
        roman_numerals.put("I", 1);
    }
}

