/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import hellfirepvp.astralsorcery.common.crafting.grindstone.CrystalSharpeningRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.CrystalToolSharpeningRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.GrindstoneRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.GrindstoneRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.grindstone.SwordSharpeningRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import wanion.unidict.integration.AbstractIntegrationThread;

public class AstralSorceryIntegration
extends AbstractIntegrationThread {
    private Field recipeChance;

    public AstralSorceryIntegration() {
        super("Astral Sorcery Integration");
        try {
            this.recipeChance = GrindstoneRecipe.class.getDeclaredField("chance");
            this.recipeChance.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            this.logger.error("Failed to find astral sorcery chance field!");
            e.printStackTrace();
        }
    }

    public String call() {
        try {
            if (this.recipeChance != null) {
                this.fixGrindstoneRecipes();
            }
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Attuned the grindstone!";
    }

    private void fixGrindstoneRecipes() {
        List recipes = GrindstoneRecipeRegistry.recipes;
        ArrayList<GrindstoneRecipe> newRecipes = new ArrayList<GrindstoneRecipe>();
        Iterator grindstoneRecipeIterator = recipes.iterator();
        while (grindstoneRecipeIterator.hasNext()) {
            GrindstoneRecipe recipe = (GrindstoneRecipe)grindstoneRecipeIterator.next();
            if (recipe instanceof CrystalSharpeningRecipe || recipe instanceof CrystalToolSharpeningRecipe || recipe instanceof SwordSharpeningRecipe) continue;
            try {
                newRecipes.add(new GrindstoneRecipe(recipe.getInputForRender(), this.resourceHandler.getMainItemStack(recipe.getOutputForMatching()), ((Integer)this.recipeChance.get(recipe)).intValue(), recipe.getChanceToDoubleOutput()));
            }
            catch (IllegalAccessException e) {
                this.logger.warn(this.threadName + "Failed to recreate grindstone recipe!");
                e.printStackTrace();
            }
            grindstoneRecipeIterator.remove();
        }
        recipes.addAll(newRecipes);
    }
}

