/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import org.jetbrains.annotations.NotNull;

public class ResourcefulFurnaceTile
extends CustomElectricMachine {
    public IFluidTank tank;
    public IItemHandler input;
    public IItemHandler output;

    public ResourcefulFurnaceTile() {
        super(ResourcefulFurnaceTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.input = this.addSimpleInventory(3, "input", EnumDyeColor.BLUE, "Input items", new BoundingRectangle(54, 25, 18, 54), (i, slot) -> !FurnaceRecipes.func_77602_a().func_151395_a(i).func_190926_b(), (o, slot) -> false, false, null);
        this.output = this.addSimpleInventory(3, "Output", EnumDyeColor.ORANGE, "Output items", new BoundingRectangle(102, 25, 18, 54), (o, slot) -> false, (o, slot) -> true, false, null);
        this.tank = this.addSimpleFluidTank(8000, "Tank", EnumDyeColor.LIME, 128, 25, FluidTankType.OUTPUT, o -> false, o -> true);
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        boolean operation = false;
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b() || !this.output.getStackInSlot(i).func_190926_b() && (!FurnaceRecipes.func_77602_a().func_151395_a(this.input.getStackInSlot(i)).func_77969_a(this.output.getStackInSlot(i)) || this.output.getStackInSlot(i).func_190916_E() >= this.output.getStackInSlot(i).func_77976_d())) continue;
            this.output.insertItem(i, FurnaceRecipes.func_77602_a().func_151395_a(this.input.getStackInSlot(i)).func_77946_l(), false);
            this.input.getStackInSlot(i).func_190918_g(1);
            this.tank.fill(new FluidStack((Fluid)FluidsRegistry.ESSENCE, (int)(FurnaceRecipes.func_77602_a().func_151398_b(this.output.getStackInSlot(i)) * (float)BlockRegistry.resourcefulFurnaceBlock.getExperienceMultiplier())), true);
            operation = true;
        }
        return operation ? 1.0f : 0.0f;
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(74, 26, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(74, 44, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(74, 62, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        return pieces;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.fillItemFromTank(fluidItems, this.tank);
    }
}

