/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.discord;

import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.configuration.GameType;
import me.hypherionmc.simplerpclib.discord.DiscordController;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;
import me.hypherionmc.simplerpclib.discord.RichPresenceState;

public class RichPresenceEvents {
    private final RichPresenceCore core;
    private RichPresenceState rpcState = RichPresenceState.INIT;
    private GameType gameType = GameType.SINGLE;
    private boolean isFirstJoin = true;

    public RichPresenceEvents(RichPresenceCore core) {
        this.core = core;
        this.initRPC();
    }

    private void initRPC() {
        this.rpcState = RichPresenceState.INIT;
        this.isFirstJoin = true;
        this.updateRPC();
    }

    public void ingameRPC(GameType type) {
        this.rpcState = RichPresenceState.IN_GAME;
        this.gameType = type;
        this.updateRPC();
    }

    public void mainMenuRPC() {
        this.rpcState = RichPresenceState.MAIN_MENU;
        this.isFirstJoin = true;
        this.updateRPC();
    }

    public void realmRPC() {
        this.rpcState = RichPresenceState.REALM_MENU;
        this.updateRPC();
    }

    public void serverListRPC() {
        this.rpcState = RichPresenceState.SERVER_MENU;
        this.isFirstJoin = true;
        this.updateRPC();
    }

    public void joiningGameRPC() {
        this.rpcState = RichPresenceState.JOINING_GAME;
        this.updateRPC();
    }

    public void joinGame() {
        if (this.isFirstJoin) {
            this.isFirstJoin = false;
        }
    }

    public void updateRPC() {
        ClientConfig clientConfig = this.core.getClientConfig();
        DiscordController discordHandler = this.core.getDiscordHandler();
        if (clientConfig != null && clientConfig.general.enabled && discordHandler != null) {
            if (this.rpcState == RichPresenceState.INIT) {
                if (clientConfig.init.buildPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.init.buildPresence(this.core).getPresence());
                } else {
                    discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                }
            } else if (this.rpcState == RichPresenceState.MAIN_MENU) {
                if (clientConfig.main_menu.buildPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.main_menu.buildPresence(this.core).getPresence());
                } else {
                    discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                }
            } else if (this.rpcState == RichPresenceState.REALM_MENU) {
                if (clientConfig.realmsScreenSection.buildPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.realmsScreenSection.buildPresence(this.core).getPresence());
                } else {
                    discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                }
            } else if (this.rpcState == RichPresenceState.SERVER_MENU) {
                if (clientConfig.server_list.buildPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.server_list.buildPresence(this.core).getPresence());
                } else {
                    discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                }
            } else if (this.rpcState == RichPresenceState.JOINING_GAME) {
                if (clientConfig.join_game.buildPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.join_game.buildPresence(this.core).getPresence());
                } else {
                    discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                }
            } else if (this.rpcState == RichPresenceState.IN_GAME) {
                if (this.gameType == GameType.SINGLE) {
                    if (clientConfig.single_player.buildPresence(this.core) != null) {
                        discordHandler.updateRichPresence(clientConfig.single_player.buildPresence(this.core).getPresence());
                    } else {
                        discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                    }
                } else if (this.gameType == GameType.MULTIPLAYER) {
                    if (clientConfig.multi_player.buildPresence(this.core) != null) {
                        discordHandler.updateRichPresence(clientConfig.multi_player.buildPresence(this.core).getPresence());
                    } else {
                        discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                    }
                } else if (this.gameType == GameType.REALM) {
                    if (clientConfig.realmsGameSection.buildPresence(this.core) != null) {
                        discordHandler.updateRichPresence(clientConfig.realmsGameSection.buildPresence(this.core).getPresence());
                    } else {
                        discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
                    }
                }
            } else {
                discordHandler.updateRichPresence(clientConfig.generic.buildPresence(this.core).getPresence());
            }
        } else if (discordHandler != null) {
            discordHandler.updateRichPresence(null);
        }
    }
}

