/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui.field;

import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.field.WField;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.client.gui.interaction.WKeyInteraction;
import wanion.lib.client.gui.interaction.WMouseInteraction;
import wanion.lib.common.INBTMessage;
import wanion.lib.common.IUpdatable;
import wanion.lib.common.field.text.TextField;

@SideOnly(value=Side.CLIENT)
public class TextFieldWElement
extends WField<TextField>
implements INBTMessage,
IUpdatable {
    private int cursorCounter;
    private final boolean enableBackgroundDrawing;
    private boolean isFocused;
    private boolean typingEnabled = true;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;

    public TextFieldWElement(@Nonnull TextField textField, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y, int width, int height) {
        this(textField, wGuiContainer, x, y, width, height, true);
        this.setInteractionCheck(interaction -> (this.isFocused || interaction.isHovering(this)) && ((TextField)this.field).canInteractWith(interaction.getEntityPlayer()));
    }

    public TextFieldWElement(@Nonnull TextField textField, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y, int width, int height, boolean enableBackgroundDrawing) {
        super(textField, wGuiContainer, x, y, width, height);
        this.enableBackgroundDrawing = enableBackgroundDrawing;
        this.setForegroundCheck(interaction -> interaction.isHovering(this) && !this.canInteractWith((WInteraction)interaction));
        this.setTooltipSupplier((interaction, stackSupplier) -> Lists.newArrayList((Object[])new String[]{((TextField)this.field).getHoveringText(interaction)}));
    }

    public void setText(String textIn) {
        this.setTextField(textIn.length() > 32 ? textIn.substring(0, 32) : textIn);
        this.setCursorPositionEnd();
    }

    private void setTextField(String text) {
        ((TextField)this.field).setContent(text);
        this.typingEnabled = false;
        ((TextField)this.field).sendTextFieldNBT(this.getWindowID(), this.getEntityPlayer(), true, text);
    }

    public String getText() {
        return ((TextField)this.field).getContent();
    }

    public String getSelectedText() {
        return this.getText().substring(Math.min(this.cursorPosition, this.selectionEnd), Math.max(this.cursorPosition, this.selectionEnd));
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = 32 - ((TextField)this.field).length() - (i - j);
        if (!((TextField)this.field).isEmpty()) {
            s = s + this.getText().substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!((TextField)this.field).isEmpty() && j < ((TextField)this.field).length()) {
            s = s + this.getText().substring(j);
        }
        this.setTextField(s);
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteWords(int num) {
        if (!((TextField)this.field).isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!((TextField)this.field).isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    s = this.getText().substring(0, i);
                }
                if (j < ((TextField)this.field).length()) {
                    s = s + this.getText().substring(j);
                }
                this.setTextField(s);
                if (flag) {
                    this.moveCursorBy(num);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = ((TextField)this.field).length();
                i = this.getText().indexOf(32, i);
                if (i == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.getText().charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.getText().charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.getText().charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)((TextField)this.field).length());
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(((TextField)this.field).length());
    }

    @Override
    public void interact(@Nonnull WKeyInteraction keyInteraction) {
        char typedChar = keyInteraction.getKey();
        int keyCode = keyInteraction.getKeyCode();
        if (!this.isFocused) {
            return;
        }
        keyInteraction.notProceed();
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
        } else if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
        } else if (GuiScreen.func_175279_e((int)keyCode)) {
            if (this.typingEnabled) {
                this.writeText(GuiScreen.func_146277_j());
            }
        } else if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.typingEnabled) {
                this.writeText("");
            }
        } else {
            switch (keyCode) {
                case 14: {
                    if (GuiScreen.func_146271_m()) {
                        if (this.typingEnabled) {
                            this.deleteWords(-1);
                        }
                    } else if (this.typingEnabled) {
                        this.deleteFromCursor(-1);
                    }
                    return;
                }
                case 199: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(0);
                    } else {
                        this.setCursorPositionZero();
                    }
                    return;
                }
                case 203: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                        } else {
                            this.setSelectionPos(this.getSelectionEnd() - 1);
                        }
                    } else if (GuiScreen.func_146271_m()) {
                        this.setCursorPosition(this.getNthWordFromCursor(-1));
                    } else {
                        this.moveCursorBy(-1);
                    }
                    return;
                }
                case 205: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                        } else {
                            this.setSelectionPos(this.getSelectionEnd() + 1);
                        }
                    } else if (GuiScreen.func_146271_m()) {
                        this.setCursorPosition(this.getNthWordFromCursor(1));
                    } else {
                        this.moveCursorBy(1);
                    }
                    return;
                }
                case 207: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(((TextField)this.field).length());
                    } else {
                        this.setCursorPositionEnd();
                    }
                    return;
                }
                case 211: {
                    if (GuiScreen.func_146271_m()) {
                        if (this.typingEnabled) {
                            this.deleteWords(1);
                        }
                    } else if (this.typingEnabled) {
                        this.deleteFromCursor(1);
                    }
                    return;
                }
            }
            if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
                if (this.typingEnabled) {
                    this.writeText(Character.toString(typedChar));
                }
            } else {
                keyInteraction.proceed();
            }
        }
    }

    @Override
    public void interact(@Nonnull WMouseInteraction mouseInteraction) {
        boolean hovering = mouseInteraction.isHovering(this);
        this.setFocused(mouseInteraction, hovering);
        if (this.isFocused && hovering && mouseInteraction.getMouseButton() == 0) {
            int i = mouseInteraction.getMouseX() - this.getUsableX();
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            String s = this.getFontRenderer().func_78269_a(this.getText().substring(this.lineScrollOffset), this.getWidth());
            this.setCursorPosition(this.getFontRenderer().func_78269_a(s, i).length() + this.lineScrollOffset);
        }
    }

    @Override
    public void draw(@Nonnull WInteraction interaction) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.enableBackgroundDrawing) {
            Gui.func_73734_a((int)(this.getUsableX() - 1), (int)(this.getUsableY() - 1), (int)(this.getUsableX() + this.width + 1), (int)(this.getUsableY() + this.height + 1), (int)-7631989);
            Gui.func_73734_a((int)this.getUsableX(), (int)this.getUsableY(), (int)(this.getUsableX() + this.width + 1), (int)(this.getUsableY() + this.height + 1), (int)-1);
            Gui.func_73734_a((int)(this.getUsableX() - 1), (int)(this.getUsableY() - 1), (int)(this.getUsableX() + this.width), (int)(this.getUsableY() + this.height), (int)-13158601);
            Gui.func_73734_a((int)this.getUsableX(), (int)this.getUsableY(), (int)(this.getUsableX() + this.width), (int)(this.getUsableY() + this.height), (int)-7631989);
        }
        FontRenderer fontRenderer = this.getFontRenderer();
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = fontRenderer.func_78269_a(this.getText().substring(this.lineScrollOffset), this.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.enableBackgroundDrawing ? this.getUsableX() + 4 : this.getUsableX();
        int i1 = this.enableBackgroundDrawing ? this.getUsableY() + (this.height - 8) / 2 : this.getUsableY();
        int j1 = l;
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = fontRenderer.func_175063_a(s1, (float)l, (float)i1, 0xFFFFFF);
        }
        boolean flag2 = this.cursorPosition < ((TextField)this.field).length() || ((TextField)this.field).length() >= 32;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.width : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            fontRenderer.func_175063_a(s.substring(j), (float)j1, (float)i1, 0xFFFFFF);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + fontRenderer.field_78288_b), (int)-1);
            } else {
                fontRenderer.func_175063_a("_", (float)k1, (float)i1, 0xFFFFFF);
            }
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setFocused(@Nonnull WMouseInteraction mouseInteraction, boolean isFocusedIn) {
        if (!this.canInteractWith(mouseInteraction)) {
            return;
        }
        if (isFocusedIn && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.typingEnabled = this.isFocused = isFocusedIn;
        ((TextField)this.field).sendTextFieldNBT(this.getWindowID(), mouseInteraction.getEntityPlayer(), this.isFocused);
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_193975_a(isFocusedIn);
        }
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    @Override
    public int getWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = ((TextField)this.field).length();
        this.selectionEnd = position = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        FontRenderer fontRenderer = this.getFontRenderer();
        if (fontRenderer == null) {
            return;
        }
        if (this.lineScrollOffset > i) {
            this.lineScrollOffset = i;
        }
        int j = this.getWidth();
        String s = fontRenderer.func_78269_a(this.getText().substring(this.lineScrollOffset), j);
        int k = s.length() + this.lineScrollOffset;
        if (position == this.lineScrollOffset) {
            this.lineScrollOffset -= fontRenderer.func_78262_a(this.getText(), j, true).length();
        }
        if (position > k) {
            this.lineScrollOffset += position - k;
        } else if (position <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - position;
        }
        this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
    }

    @Override
    public void receiveNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (!nbtTagCompound.func_74779_i("fieldName").equals(((TextField)this.field).getFieldName())) {
            return;
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.typingEnabled = true;
    }

    @Override
    public void update(double seconds) {
        String text = this.getText();
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)text.length());
        this.selectionEnd = MathHelper.func_76125_a((int)this.selectionEnd, (int)0, (int)text.length());
    }
}

