/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import nihiltres.engineersdoors.common.module.IModule;

public abstract class AbstractModule
implements IModule {
    private final String name;
    protected final ArrayList<Block> blocks = new ArrayList();
    protected final ArrayList<Item> items = new ArrayList();
    protected final ArrayList<IRecipe> recipes = new ArrayList();
    protected final ArrayList<SoundEvent> soundEvents = new ArrayList();
    protected final ArrayList<Class<? extends TileEntity>> tileEntities = new ArrayList();

    protected AbstractModule(String nameIn) {
        this.name = nameIn;
    }

    protected boolean addBlocks(Collection<Block> c) {
        return this.blocks.addAll(c);
    }

    protected boolean addBlocks(Block ... a) {
        return this.blocks.addAll(Arrays.asList(a));
    }

    protected boolean addItems(Collection<Item> c) {
        return this.items.addAll(c);
    }

    protected boolean addItems(Item ... a) {
        return this.items.addAll(Arrays.asList(a));
    }

    protected boolean addRecipes(Collection<IRecipe> c) {
        return this.recipes.addAll(c);
    }

    protected boolean addRecipes(IRecipe ... a) {
        return this.recipes.addAll(Arrays.asList(a));
    }

    protected boolean addSoundEvents(Collection<SoundEvent> c) {
        return this.soundEvents.addAll(c);
    }

    protected boolean addSoundEvents(SoundEvent ... a) {
        return this.soundEvents.addAll(Arrays.asList(a));
    }

    protected boolean addTileEntities(Collection<Class<? extends TileEntity>> c) {
        return this.tileEntities.addAll(c);
    }

    @SafeVarargs
    protected final boolean addTileEntities(Class<? extends TileEntity> ... a) {
        return this.tileEntities.addAll(Arrays.asList(a));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    public Collection<Item> getItems() {
        return this.items;
    }

    @Override
    public Collection<IRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }

    @Override
    public Collection<Class<? extends TileEntity>> getTileEntities() {
        return this.tileEntities;
    }
}

