/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.Position3f;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IExplosion;
import crafttweaker.api.world.IRayTraceResult;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import crafttweaker.api.world.IWorldInfo;
import crafttweaker.api.world.IWorldProvider;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.util.MCPosition3f;
import crafttweaker.mc1120.world.MCBiome;
import crafttweaker.mc1120.world.MCBlockAccess;
import crafttweaker.mc1120.world.MCWorldInfo;
import crafttweaker.mc1120.world.MCWorldProvider;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import stanhebben.zenscript.annotations.Optional;

public class MCWorld
extends MCBlockAccess
implements IWorld {
    private final World world;

    public MCWorld(World world) {
        super((IBlockAccess)world);
        this.world = world;
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        return this.world.func_175699_k(new BlockPos(x, y, z));
    }

    @Override
    public int getBrightness(IBlockPos pos) {
        return this.world.func_175699_k((BlockPos)pos.getInternal());
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        return CraftTweakerMC.getBlock((IBlockAccess)this.world, x, y, z);
    }

    @Override
    public IBlock getBlock(IBlockPos pos) {
        return CraftTweakerMC.getBlock((IBlockAccess)this.world, pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public IBiome getBiome(Position3f position) {
        return this.getBiome(position.asBlockPos());
    }

    @Override
    public IBiome getBiome(IBlockPos position) {
        return new MCBiome(this.world.func_180494_b((BlockPos)position.getInternal()));
    }

    @Override
    public IWorldInfo getWorldInfo() {
        return new MCWorldInfo(this.world.func_72912_H());
    }

    @Override
    public boolean isRemote() {
        return this.world.field_72995_K;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72896_J();
    }

    @Override
    public boolean isDayTime() {
        return this.world.func_72935_r();
    }

    @Override
    public boolean isSurfaceWorld() {
        return this.world.field_73011_w.func_76569_d();
    }

    @Override
    public long getWorldTime() {
        return this.world.func_82737_E();
    }

    @Override
    public int getMoonPhase() {
        return this.world.field_73011_w.func_76559_b(this.world.func_72820_D());
    }

    @Override
    public int getDimension() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public String getDimensionType() {
        return this.world.field_73011_w.func_186058_p().func_186065_b();
    }

    @Override
    public String getWorldType() {
        return this.world.func_175624_G().func_77127_a();
    }

    @Override
    public Object getInternal() {
        return this.world;
    }

    @Override
    public boolean spawnEntity(IEntity entity) {
        return this.world.func_72838_d(CraftTweakerMC.getEntity(entity));
    }

    @Override
    public void removeEntity(IEntity entity) {
        this.world.func_72900_e(CraftTweakerMC.getEntity(entity));
    }

    @Override
    public IRayTraceResult rayTraceBlocks(IVector3d begin, IVector3d ray, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return CraftTweakerMC.getIRayTraceResult(this.world.func_147447_a(CraftTweakerMC.getVec3d(begin), CraftTweakerMC.getVec3d(ray), stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock));
    }

    @Override
    public List<IEntity> getEntitiesInArea(Position3f start, @Optional Position3f end) {
        if (end == null) {
            end = new MCPosition3f(start.getX() + 1.0f, start.getY() + 1.0f, start.getZ() + 1.0f);
        }
        return this.world.func_72839_b(null, new AxisAlignedBB((BlockPos)start.asBlockPos().getInternal(), (BlockPos)end.asBlockPos().getInternal())).stream().map(CraftTweakerMC::getIEntity).collect(Collectors.toList());
    }

    @Override
    public boolean setBlockState(crafttweaker.api.block.IBlockState state, IBlockPos pos) {
        return this.world.func_175656_a((BlockPos)pos.getInternal(), (IBlockState)state.getInternal());
    }

    @Override
    public boolean setBlockState(crafttweaker.api.block.IBlockState state, IData tileEntityData, IBlockPos pos) {
        NBTTagCompound tileEntityNBT;
        boolean placed = this.world.func_175656_a((BlockPos)pos.getInternal(), (IBlockState)state.getInternal());
        if (tileEntityData != null && !(tileEntityNBT = (NBTTagCompound)NBTConverter.from(tileEntityData)).func_82582_d()) {
            TileEntity tileEntity = this.world.func_175625_s((BlockPos)pos.getInternal());
            if (tileEntity != null) {
                NBTTagCompound currentNBT = tileEntity.func_189515_b(new NBTTagCompound());
                NBTTagCompound originalNBT = currentNBT.func_74737_b();
                currentNBT.func_179237_a(tileEntityNBT.func_74737_b());
                currentNBT.func_74768_a("x", pos.getX());
                currentNBT.func_74768_a("y", pos.getY());
                currentNBT.func_74768_a("z", pos.getZ());
                if (!currentNBT.equals((Object)originalNBT)) {
                    tileEntity.func_145839_a(currentNBT);
                    tileEntity.func_70296_d();
                }
            } else {
                CraftTweakerAPI.logInfo("No tile entity found when placing block.");
            }
        }
        return placed;
    }

    @Override
    public IWorldProvider getProvider() {
        return new MCWorldProvider(this.world.field_73011_w);
    }

    @Override
    public IItemStack getPickedBlock(IBlockPos pos, IRayTraceResult rayTraceResult, IPlayer player) {
        BlockPos blockPos = CraftTweakerMC.getBlockPos(pos);
        IBlockState state = this.world.func_180495_p(blockPos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, CraftTweakerMC.getRayTraceResult(rayTraceResult), this.world, blockPos, CraftTweakerMC.getPlayer(player));
        return CraftTweakerMC.getIItemStack(stack);
    }

    @Override
    public IExplosion createExplosion(IEntity exploder, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        return CraftTweakerMC.getIExplosion(new Explosion(this.world, CraftTweakerMC.getEntity(exploder), x, y, z, strength, causesFire, damagesTerrain));
    }

    @Override
    public IExplosion performExplosion(IEntity exploder, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        return CraftTweakerMC.getIExplosion(this.world.func_72885_a(CraftTweakerMC.getEntity(exploder), x, y, z, strength, causesFire, damagesTerrain));
    }

    @Override
    public IExplosion performExplosion(IExplosion explosion) {
        if (ForgeEventFactory.onExplosionStart((World)this.world, (Explosion)CraftTweakerMC.getExplosion(explosion))) {
            return explosion;
        }
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        return explosion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MCWorld mcWorld = (MCWorld)o;
        return Objects.equals(this.world, mcWorld.world);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.world);
    }
}

