/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.event;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.render.MuseIconUtils;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.common.item.IModularItem;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.powersuits.client.control.KeybindManager;
import net.machinemuse.powersuits.client.control.MPSKeyBinding;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.model.helper.ModelHelper;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.common.config.MPSSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderEventHandler {
    private static final MPSConfig config = MPSConfig.INSTANCE;
    private static boolean ownFly;
    private final DrawableMuseRect frame = new DrawableMuseRect(config.keybindHUDx(), config.keybindHUDy(), config.keybindHUDx() + 16.0, config.keybindHUDy() + 16.0, true, Colour.DARKGREEN.withAlpha(0.2), Colour.GREEN.withAlpha(0.2));
    static List<KBDisplay> kbDisplayList;

    public RenderEventHandler() {
        ownFly = false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void preTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().equals(Minecraft.func_71410_x().func_147117_R())) {
            MuseIcon.registerIcons(event.getMap());
            ModelHelper.loadArmorModels(event.getMap());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution screen = new ScaledResolution(mc);
    }

    @SubscribeEvent
    public void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!event.getEntityPlayer().field_71075_bZ.field_75100_b && !event.getEntityPlayer().field_70122_E && this.playerHasFlightOn(event.getEntityPlayer())) {
            event.getEntityPlayer().field_71075_bZ.field_75100_b = true;
            ownFly = true;
        }
    }

    private boolean playerHasFlightOn(EntityPlayer player) {
        return ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "jetpack") || ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "glider") || ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.FEET), "jetBoots") || ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.HEAD), "flightControl");
    }

    @SubscribeEvent
    public void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ownFly) {
            ownFly = false;
            event.getEntityPlayer().field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent e) {
        ItemStack helmet = e.getEntity().func_184582_a(EntityEquipmentSlot.HEAD);
        if (ModuleManager.INSTANCE.itemHasActiveModule(helmet, "binoculars")) {
            e.setNewfov(e.getNewfov() / (float)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(helmet, "fieldOfView"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        RenderGameOverlayEvent.ElementType elementType = e.getType();
        if (RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)elementType)) {
            this.drawKeybindToggles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawKeybindToggles() {
        if (config.keybindHUDon()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            ScaledResolution screen = new ScaledResolution(mc);
            if (!Arrays.stream(EntityEquipmentSlot.values()).filter(slot -> player.func_184582_a(slot).func_77973_b() instanceof IModularItem).collect(Collectors.toList()).isEmpty()) {
                AtomicDouble top = new AtomicDouble(MPSSettings.hud.keybindHUDy);
                kbDisplayList.forEach(kbDisplay -> {
                    if (!kbDisplay.boundKeybinds.isEmpty()) {
                        kbDisplay.setLeft(MPSSettings.hud.keybindHUDx);
                        kbDisplay.setTop(top.get());
                        kbDisplay.setBottom(top.get() + 16.0);
                        kbDisplay.render(0.0, 0.0, mc.func_184121_ak());
                        top.getAndAdd(18.0);
                    }
                });
            }
        }
    }

    public static void makeKBDisplayList() {
        kbDisplayList.clear();
        KeybindManager.INSTANCE.getMPSKeybinds().filter(kb -> kb.func_151463_i() > 0).filter(kb -> kb.showOnHud).forEach(kb -> {
            Optional<KBDisplay> kbDisplay = kbDisplayList.stream().filter(kbd -> Objects.equals(kbd.id, kb.func_151463_i()) && Objects.equals(kb.getKeyModifier(), kbd)).findFirst();
            if (kbDisplay.isPresent()) {
                kbDisplay.map(kbd -> kbd.boundKeybinds.add((MPSKeyBinding)((Object)kb)));
            } else {
                kbDisplayList.add(new KBDisplay((MPSKeyBinding)((Object)kb), MPSSettings.hud.keybindHUDx, MPSSettings.hud.keybindHUDy, MPSSettings.hud.keybindHUDx + 16.0));
            }
        });
    }

    static {
        kbDisplayList = new ArrayList<KBDisplay>();
    }

    static class KBDisplay
    extends DrawableMuseRect {
        List<MPSKeyBinding> boundKeybinds = new ArrayList<MPSKeyBinding>();
        final int id;
        final KeyModifier modifier;
        String label;

        public KBDisplay(MPSKeyBinding kb, double left, double top, double right) {
            super(left, top, right, top + 16.0, true, Colour.DARKGREEN.withAlpha((double)0.2f), Colour.GREEN.withAlpha((double)0.2f));
            this.id = kb.func_151463_i();
            this.boundKeybinds.add(kb);
            this.modifier = kb.getKeyModifier();
            this.label = kb.getDisplayName();
        }

        public void render(double mouseX, double mouseY, float partialTick) {
            float stringwidth = (float)MuseRenderer.getStringWidth((String)this.label);
            this.setWidth(stringwidth + 8.0f + (float)(this.boundKeybinds.stream().filter(kb -> kb.showOnHud).collect(Collectors.toList()).size() * 18));
            super.render(mouseX, mouseY, partialTick);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            boolean kbToggleVal = this.boundKeybinds.stream().filter(kb -> kb.toggleval).findFirst().isPresent();
            MuseRenderer.drawLeftAlignedStringString((String)this.label, (double)((float)this.left() + 4.0f), (double)((float)this.top() + 4.0f), (Colour)(kbToggleVal ? Colour.RED : Colour.GREEN));
            GlStateManager.func_179121_F();
            AtomicDouble x = new AtomicDouble(this.left() + (double)stringwidth + 8.0);
            this.boundKeybinds.stream().filter(kb -> kb.showOnHud).forEach(kb -> {
                boolean active = false;
                IPowerModule module = ModuleManager.INSTANCE.getModule(kb.dataName);
                if (module != null) {
                    for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184582_a(slot);
                        if (!ModuleManager.INSTANCE.itemHasActiveModule(stack, module.getDataName())) continue;
                        active = true;
                    }
                    MuseTextureUtils.pushTexture((String)"textures/atlas/blocks.png");
                    MuseIconUtils.drawIconAt((double)x.get(), (double)this.top(), (TextureAtlasSprite)module.getIcon(null), (Colour)(active ? Colour.WHITE : Colour.DARKGREY.withAlpha(0.5)));
                    MuseTextureUtils.popTexture();
                    x.getAndAdd(16.0);
                }
            });
        }
    }
}

