/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.numina.client.gui.clickable.ClickableItem;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.FlyFromPointToPoint2D;
import net.machinemuse.numina.client.gui.geometry.GradientAndArcCalculator;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class ItemSelectionFrame<T extends IRect>
extends ScrollableFrame {
    public List<ClickableItem> itemButtons;
    protected int selectedItemStack = -1;
    protected EntityPlayer player;
    protected List<MusePoint2D> itemPoints;
    protected int lastItemSlot = -1;

    public ItemSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, EntityPlayer player) {
        super((IRect)new DrawableMuseRect(topleft, bottomright, borderColour, insideColour));
        this.player = player;
        List slots = MuseItemUtils.getModularItemSlotsInInventory((EntityPlayer)player);
        this.loadPoints(slots.size());
        this.loadItems();
    }

    public int getLastItemSlot() {
        return this.lastItemSlot;
    }

    public int getSelectedItemSlot() {
        return this.selectedItemStack;
    }

    private void loadPoints(int num) {
        double centerX = (this.left() + this.right()) / 2.0;
        double centery = (this.top() + this.bottom()) / 2.0;
        this.itemPoints = new ArrayList<MusePoint2D>();
        List targetPoints = GradientAndArcCalculator.pointsInLine((int)num, (MusePoint2D)new MusePoint2D(centerX, this.bottom()), (MusePoint2D)new MusePoint2D(centerX, this.top()));
        for (MusePoint2D point : targetPoints) {
            this.itemPoints.add((MusePoint2D)new FlyFromPointToPoint2D(new MusePoint2D(centerX, centery), point, 200.0));
        }
    }

    private void loadItems() {
        if (this.player != null) {
            this.itemButtons = new ArrayList<ClickableItem>();
            List slots = MuseItemUtils.getModularItemSlotsInInventory((EntityPlayer)this.player);
            if (slots.size() > this.itemPoints.size()) {
                this.loadPoints(slots.size());
            }
            if (slots.size() > 0) {
                Iterator<MusePoint2D> pointiterator = this.itemPoints.iterator();
                Iterator iterator = slots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    ClickableItem clickie = new ClickableItem(this.player.field_71071_by.func_70301_a(slot), pointiterator.next(), slot);
                    this.itemButtons.add(clickie);
                }
            }
        }
    }

    public void update(double mouseX, double mouseY) {
        this.loadItems();
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        this.drawBackground(mouseX, mouseY, partialTicks);
        this.drawItems(mouseX, mouseY, partialTicks);
        this.drawSelection();
    }

    private void drawBackground(double mouseX, double mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
    }

    private void drawItems(double mouseX, double mouseY, float partialTicks) {
        for (ClickableItem item : this.itemButtons) {
            item.render(mouseX, mouseY, partialTicks);
        }
    }

    private void drawSelection() {
        if (this.selectedItemStack != -1) {
            MuseRenderer.drawCircleAround((double)Math.floor(this.itemButtons.get(this.selectedItemStack).getPosition().getX()), (double)Math.floor(this.itemButtons.get(this.selectedItemStack).getPosition().getY()), (double)10.0);
        }
    }

    public boolean hasNoItems() {
        return this.itemButtons.size() == 0;
    }

    public ClickableItem getPreviousSelectedItem() {
        if (this.itemButtons.size() > this.lastItemSlot && this.lastItemSlot != -1) {
            return this.itemButtons.get(this.lastItemSlot);
        }
        return null;
    }

    public ClickableItem getSelectedItem() {
        if (this.itemButtons.size() > this.selectedItemStack && this.selectedItemStack != -1) {
            return this.itemButtons.get(this.selectedItemStack);
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int i = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.containsPoint(mouseX, mouseY)) {
                this.lastItemSlot = this.selectedItemStack;
                Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, null);
                this.selectedItemStack = i;
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<String> getToolTip(double mouseX, double mouseY) {
        int itemHover = -1;
        int i = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.containsPoint(mouseX, mouseY)) {
                itemHover = i;
                break;
            }
            ++i;
        }
        if (itemHover > -1) {
            return this.itemButtons.get(itemHover).getToolTip(mouseX, mouseY);
        }
        return null;
    }
}

