/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.module.tinker;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.client.gui.clickable.ClickableItem;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.geometry.MuseRect;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.powersuits.client.gui.common.ClickableModule;
import net.machinemuse.powersuits.client.gui.common.ItemSelectionFrame;
import net.machinemuse.powersuits.client.gui.module.tinker.ModuleSelectionSubFrame;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class ModuleSelectionFrame
extends ScrollableFrame {
    protected ItemSelectionFrame target;
    protected Map<String, ModuleSelectionSubFrame> categories = new LinkedHashMap<String, ModuleSelectionSubFrame>();
    protected List<ClickableModule> moduleButtons = new LinkedList<ClickableModule>();
    protected int selectedModule = -1;
    protected IPowerModule prevSelection;
    protected ClickableItem lastItem;
    protected MuseRect lastPosition;

    public ModuleSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame target) {
        super((IRect)new DrawableMuseRect(topleft, bottomright, borderColour, insideColour));
        this.target = target;
    }

    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.refreshButtonPositions();
        }
        if (this.target.getSelectedItem() != null) {
            if (this.lastItem != this.target.getSelectedItem()) {
                this.loadModules();
            }
            this.totalSize = 0;
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                this.totalSize = (int)Math.max(frame.border.bottom() - this.top(), (double)this.totalSize);
            }
            this.currentScrollPixels = Math.min(this.currentScrollPixels, this.getMaxScrollPixels());
            super.preRender(mouseX, mouseY, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)(-this.currentScrollPixels), (double)0.0);
            this.drawItems();
            this.drawSelection();
            GlStateManager.func_179121_F();
            super.postRender(mouseX, mouseY, partialTicks);
        }
    }

    private void drawItems() {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.drawPartial((int)(this.currentScrollPixels + this.top() + 4.0), (int)(this.currentScrollPixels + this.top() + this.height() - 4.0));
        }
    }

    private void drawSelection() {
        MusePoint2D pos;
        ClickableModule module = this.getSelectedModule();
        if (module != null && (pos = this.moduleButtons.get(this.selectedModule).getPosition()).getY() > this.currentScrollPixels + this.top() + 4.0 && pos.getY() < this.currentScrollPixels + this.top() + this.height() - 4.0) {
            MuseRenderer.drawCircleAround((double)pos.getX(), (double)pos.getY(), (double)10.0);
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.moduleButtons.size() > this.selectedModule && this.selectedModule != -1) {
            return this.moduleButtons.get(this.selectedModule);
        }
        return null;
    }

    public void loadModules() {
        this.lastPosition = null;
        ClickableItem selectedItem = this.target.getSelectedItem();
        if (selectedItem != null) {
            this.moduleButtons = new LinkedList<ClickableModule>();
            this.categories = new LinkedHashMap<String, ModuleSelectionSubFrame>();
            List workingModules = ModuleManager.INSTANCE.getValidModulesForItem(selectedItem.getItem());
            Iterator it = workingModules.iterator();
            while (it.hasNext()) {
                IPowerModule module = (IPowerModule)it.next();
                if (module.isAllowed() || ModuleManager.INSTANCE.itemHasModule(selectedItem.getItem(), module.getDataName())) continue;
                it.remove();
            }
            if (workingModules.size() > 0) {
                this.selectedModule = -1;
                for (IPowerModule module : workingModules) {
                    ModuleSelectionSubFrame frame = this.getOrCreateCategory(module.getCategory().getName());
                    ClickableModule moduleClickable = frame.addModule(module);
                    if (!module.isAllowed()) {
                        moduleClickable.setAllowed(false);
                    } else if (ModuleManager.INSTANCE.itemHasModule(selectedItem.getItem(), module.getDataName())) {
                        moduleClickable.setInstalled(true);
                    }
                    if (moduleClickable.getModule().equals(this.prevSelection)) {
                        this.selectedModule = this.moduleButtons.size();
                    }
                    this.moduleButtons.add(moduleClickable);
                }
            }
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                frame.refreshButtonPositions();
            }
        }
    }

    private ModuleSelectionSubFrame getOrCreateCategory(String category) {
        if (this.categories.containsKey(category)) {
            return this.categories.get(category);
        }
        MuseRect position = new MuseRect(this.left() + 4.0, this.top() + 4.0, this.right() - 4.0, this.top() + 32.0);
        position.setBelow((IRect)this.lastPosition);
        this.lastPosition = position;
        ModuleSelectionSubFrame frame = new ModuleSelectionSubFrame(category, position);
        this.categories.put(category, frame);
        return frame;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            if (this.left() < mouseX && this.right() > mouseX && this.top() < mouseY && this.bottom() > mouseY) {
                mouseY += this.currentScrollPixels;
                int i = 0;
                for (ClickableModule module : this.moduleButtons) {
                    if (module.containsPoint(mouseX, mouseY)) {
                        Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, null);
                        this.selectedModule = i;
                        this.prevSelection = module.getModule();
                        return true;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public List<String> getToolTip(double mouseX, double mouseY) {
        if (this.left() < mouseX && this.right() > mouseX && this.top() < mouseY && this.bottom() > mouseY) {
            mouseY += this.currentScrollPixels;
            if (this.moduleButtons != null) {
                int moduleHover = -1;
                int i = 0;
                for (ClickableModule module : this.moduleButtons) {
                    if (module.containsPoint(mouseX, mouseY)) {
                        moduleHover = i;
                        break;
                    }
                    ++i;
                }
                if (moduleHover > -1) {
                    return this.moduleButtons.get(moduleHover).getToolTip(mouseX, mouseY);
                }
                return null;
            }
        }
        return null;
    }
}

