/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.machinemuse.numina.common.base.MuseLogger;
import net.machinemuse.numina.common.item.IModularItem;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.machinemuse.numina.common.network.MuseByteBufferUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketCosmeticInfo
implements IMessage {
    EntityPlayer player;
    int itemSlot;
    String tagName;
    NBTTagCompound tagData;

    public MusePacketCosmeticInfo() {
    }

    public MusePacketCosmeticInfo(EntityPlayer player, int itemSlot, String tagName, NBTTagCompound tagData) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.tagName = tagName;
        this.tagData = tagData;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemSlot = buf.readInt();
        this.tagName = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
        this.tagData = MuseByteBufferUtils.readCompressedNBT((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemSlot);
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.tagName);
        MuseByteBufferUtils.writeCompressedNBT((ByteBuf)buf, (NBTTagCompound)this.tagData);
    }

    public static class Handler
    implements IMessageHandler<MusePacketCosmeticInfo, IMessage> {
        public IMessage onMessage(MusePacketCosmeticInfo message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    int itemSlot = message.itemSlot;
                    String tagName = message.tagName;
                    NBTTagCompound tagData = message.tagData;
                    ItemStack stack = player.field_71071_by.func_70301_a(itemSlot);
                    if (tagName != null && stack.func_77973_b() instanceof IModularItem) {
                        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag((ItemStack)stack);
                        itemTag.func_82580_o("cosmeticPreset");
                        if (Objects.equals(tagName, "render")) {
                            itemTag.func_82580_o("render");
                            if (!tagData.func_82582_d()) {
                                itemTag.func_74782_a("render", (NBTBase)tagData);
                            }
                        } else {
                            NBTTagCompound renderTag;
                            if (!itemTag.func_74764_b("render")) {
                                renderTag = new NBTTagCompound();
                                itemTag.func_74782_a("render", (NBTBase)renderTag);
                            } else {
                                renderTag = itemTag.func_74775_l("render");
                            }
                            if (tagData.func_82582_d()) {
                                MuseLogger.logDebug((String)("Removing tag " + tagName));
                                renderTag.func_82580_o(tagName);
                            } else {
                                MuseLogger.logDebug((String)("Adding tag " + tagName + " : " + tagData));
                                renderTag.func_74782_a(tagName, (NBTBase)tagData);
                            }
                        }
                    }
                });
            }
            return null;
        }
    }
}

