/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.energy_generation;

import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.heat.MuseHeatUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPlayerTickModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class AdvancedSolarGenerator
extends PowerModuleBase
implements IPlayerTickModule {
    public AdvancedSolarGenerator(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solarPanel, (int)3));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.computerChip, (int)1));
        this.addBasePropertyDouble("daytimeEnergyGen", 45000.0, "RF");
        this.addBasePropertyDouble("nightTimeEnergyGen", 1500.0, "RF");
        this.addBasePropertyDouble("daytimeHeatGen", 15.0);
        this.addBasePropertyDouble("nightTimeHeatGen", 5.0);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_ENERGY_GENERATION;
    }

    public String getDataName() {
        return "advSolarGenerator";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemPowerArmorHelmet) {
            boolean moonVisible;
            World world = player.field_70170_p;
            boolean canRain = true;
            if (world.func_82737_E() % 20L == 0L) {
                canRain = world.func_180494_b(player.func_180425_c()).func_76738_d();
            }
            boolean isRaining = canRain && (world.func_72896_J() || world.func_72911_I());
            boolean sunVisible = world.func_72935_r() && !isRaining && world.func_175710_j(player.func_180425_c().func_177984_a());
            boolean bl = moonVisible = !world.func_72935_r() && !isRaining && world.func_175710_j(player.func_180425_c().func_177984_a());
            if (!world.field_72995_K && world.field_73011_w.func_191066_m() && world.func_82737_E() % 80L == 0L) {
                double lightLevelScaled = (double)(world.func_175642_b(EnumSkyBlock.SKY, player.func_180425_c().func_177984_a()) - world.func_175657_ab()) / 15.0;
                if (sunVisible) {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (int)((int)(ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "daytimeEnergyGen") * lightLevelScaled)));
                    MuseHeatUtils.heatPlayer((EntityPlayer)player, (double)(ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "daytimeHeatGen") * lightLevelScaled / 2.0));
                } else if (moonVisible) {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (int)((int)(ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "nightTimeEnergyGen") * lightLevelScaled)));
                    MuseHeatUtils.heatPlayer((EntityPlayer)player, (double)(ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "nightTimeHeatGen") * lightLevelScaled / 2.0));
                }
            }
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.advSolarGenerator;
    }
}

