/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.movement;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.base.MuseLogger;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.numina.common.player.NuminaPlayerUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.common.utils.MusePlayerUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlinkDriveModule
extends PowerModuleBase
implements IRightClickModule {
    public BlinkDriveModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.ionThruster, (int)1));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.fieldEmitter, (int)2));
        this.addBasePropertyDouble("blinkDriveEnergyCon", 10000.0, "RF");
        this.addBasePropertyDouble("blinkDriveRange", 5.0, "m");
        this.addTradeoffPropertyDouble("range", "blinkDriveEnergyCon", 30000.0);
        this.addTradeoffPropertyDouble("range", "blinkDriveRange", 59.0);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    public String getDataName() {
        return "blinkDrive";
    }

    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        SoundEvent enderman_portal = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.endermen.teleport"));
        int range = (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "blinkDriveRange");
        int energyConsumption = this.getEnergyUsage(itemStackIn);
        if (ElectricItemUtils.getPlayerEnergy((EntityPlayer)playerIn) > energyConsumption) {
            NuminaPlayerUtils.resetFloatKickTicks((EntityPlayer)playerIn);
            int amountDrained = ElectricItemUtils.drainPlayerEnergy((EntityPlayer)playerIn, (int)energyConsumption);
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), enderman_portal, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            MuseLogger.logDebug((String)("Range: " + range));
            RayTraceResult hitRayTrace = MusePlayerUtils.doCustomRayTrace(playerIn.field_70170_p, playerIn, true, range);
            MuseLogger.logDebug((String)("Hit:" + hitRayTrace));
            MusePlayerUtils.teleportEntity(playerIn, hitRayTrace);
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), enderman_portal, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            MuseLogger.logDebug((String)("blink drive anount drained: " + amountDrained));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "blinkDriveEnergyCon");
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.blinkDrive;
    }
}

