/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.helper.ToolHelpers;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HoeModule
extends PowerModuleBase
implements IPowerModule,
IRightClickModule {
    public HoeModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)1));
        this.addBasePropertyDouble("hoeEnergyCon", 500.0, "RF");
        this.addTradeoffPropertyDouble("radius", "hoeEnergyCon", 9500.0);
        this.addTradeoffPropertyDouble("radius", "hoeSearchRad", 8.0, "m");
    }

    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUse(ItemStack itemStack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        double energyConsumed = this.getEnergyUsage(itemStack);
        if (!playerIn.func_175151_a(pos, facing, itemStack) || (double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)playerIn) < energyConsumed) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)itemStack, (EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        double radius = (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "hoeSearchRad");
        int i = (int)Math.floor(-radius);
        while ((double)i < radius) {
            int j = (int)Math.floor(-radius);
            while ((double)j < radius) {
                if ((double)(i * i + j * j) < radius * radius) {
                    BlockPos newPos = pos.func_177982_a(i, 0, j);
                    IBlockState iblockstate = worldIn.func_180495_p(newPos);
                    Block block = iblockstate.func_177230_c();
                    if (facing != EnumFacing.DOWN && (worldIn.func_175623_d(newPos.func_177984_a()) || ToolHelpers.blockCheckAndHarvest((EntityPlayer)playerIn, (World)worldIn, (BlockPos)newPos.func_177984_a()))) {
                        if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                            this.setBlock(itemStack, playerIn, worldIn, newPos, Blocks.field_150458_ak.func_176223_P());
                        }
                        if (block == Blocks.field_150346_d) {
                            switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                                case DIRT: {
                                    this.setBlock(itemStack, playerIn, worldIn, newPos, Blocks.field_150458_ak.func_176223_P());
                                    break;
                                }
                                case COARSE_DIRT: {
                                    this.setBlock(itemStack, playerIn, worldIn, newPos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return EnumActionResult.SUCCESS;
    }

    protected void setBlock(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "hoeEnergyCon")));
            worldIn.func_180501_a(pos, state, 11);
        }
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "hoeEnergyCon");
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    public String getDataName() {
        return "hoe";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(Items.field_151013_M)).func_177554_e();
    }
}

