/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IBlockBreakingModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PickaxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    protected static final ItemStack emulatedTool = new ItemStack(Items.field_151035_b);

    public PickaxeModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), new ItemStack(Items.field_151042_j, 3));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)1));
        this.addBasePropertyDouble("pickaxeEnergyCon", 500.0, "RF");
        this.addBasePropertyDouble("pickHarvSpd", 8.0, "x");
        this.addTradeoffPropertyDouble("overclock", "pickaxeEnergyCon", 9500.0);
        this.addTradeoffPropertyDouble("overclock", "pickHarvSpd", 52.0);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    public String getDataName() {
        return "pickaxe";
    }

    public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving, int playerEnergy) {
        if (this.canHarvestBlock(itemStack, state, (EntityPlayer)entityLiving, pos, playerEnergy)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)((EntityPlayer)entityLiving), (int)this.getEnergyUsage(itemStack));
            return true;
        }
        return false;
    }

    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.setNewSpeed((float)((double)event.getNewSpeed() * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(event.getEntityPlayer().field_71071_by.func_70448_g(), "pickHarvSpd")));
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "pickaxeEnergyCon");
    }

    public ItemStack getEmulatedTool() {
        return emulatedTool;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.pickaxe;
    }
}

