/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.utils.modulehelpers;

import java.util.LinkedList;
import java.util.List;
import net.machinemuse.numina.common.string.MuseStringUtils;
import net.machinemuse.powersuits.client.gui.hud.FluidMeter;
import net.machinemuse.powersuits.common.capabilities.MPSChestPlateFluidHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidUtils {
    ItemStack itemStack;
    EntityPlayer player;
    FluidTank fluidTank;
    String dataName;

    public FluidUtils(EntityPlayer player, ItemStack itemStack, String dataName) {
        this.player = player;
        this.itemStack = itemStack;
        this.dataName = dataName;
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        this.fluidTank = fluidHandler instanceof MPSChestPlateFluidHandler ? ((MPSChestPlateFluidHandler)fluidHandler).getFluidTank(dataName) : null;
    }

    public List<String> getFluidDisplayString() {
        LinkedList<String> currentTipList = new LinkedList<String>();
        int fluidLevel = this.getFluidLevel();
        int maxFluidLevel = this.getMaxFluidLevel();
        if (this.fluidTank != null && maxFluidLevel > 0 && fluidLevel > 0) {
            String fluidInfo = I18n.func_135052_a((String)this.fluidTank.getFluid().getLocalizedName(), (Object[])new Object[0]) + " " + MuseStringUtils.formatNumberShort((double)fluidLevel) + '/' + MuseStringUtils.formatNumberShort((double)maxFluidLevel);
            currentTipList.add(MuseStringUtils.wrapMultipleFormatTags((String)fluidInfo, (Object[])new Object[]{Character.valueOf(MuseStringUtils.FormatCodes.Italic.character), MuseStringUtils.FormatCodes.Indigo}));
            fluidInfo = MuseStringUtils.formatNumberFromUnits((double)((double)this.fluidTank.getFluid().getFluid().getTemperature() - 273.15), (String)"\u00b0C");
            currentTipList.add(MuseStringUtils.wrapMultipleFormatTags((String)fluidInfo, (Object[])new Object[]{Character.valueOf(MuseStringUtils.FormatCodes.Italic.character), MuseStringUtils.FormatCodes.Indigo}));
        }
        return currentTipList;
    }

    public int getFluidLevel() {
        return this.fluidTank != null ? this.fluidTank.getFluidAmount() : 0;
    }

    public int getMaxFluidLevel() {
        return this.fluidTank != null ? this.fluidTank.getCapacity() : 0;
    }

    public double getFluidMass() {
        FluidStack fluid;
        FluidStack fluidStack = fluid = this.fluidTank != null ? this.fluidTank.getFluid() : null;
        if (fluid != null) {
            return fluid.amount / 1000 * fluid.getFluid().getDensity();
        }
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public FluidMeter getFluidMeter() {
        if (this.fluidTank.getFluid() != null) {
            return new FluidMeter(this.fluidTank.getFluid().getFluid());
        }
        return null;
    }

    public double getCoolingEfficiency() {
        FluidStack fluid;
        FluidStack fluidStack = fluid = this.fluidTank != null ? this.fluidTank.getFluid() : null;
        if (fluid != null) {
            double volumeEfficiency = this.fluidTank.getFluidAmount() / this.fluidTank.getCapacity();
            int boilingPointOfWater = 100;
            int fluidTemperatureInCelsius = fluid.getFluid().getTemperature() - 273;
            int temperatureEfficiency = boilingPointOfWater - fluidTemperatureInCelsius;
            return (double)temperatureEfficiency * volumeEfficiency;
        }
        return 0.0;
    }

    public int drain(int amount) {
        if (this.fluidTank != null) {
            this.fluidTank.drain(amount, true);
        }
        return 0;
    }

    public double getHeat() {
        return this.getFluidMass() * (double)this.getFluidTemperature();
    }

    public int getViscosity() {
        FluidStack fluid;
        FluidStack fluidStack = fluid = this.fluidTank != null ? this.fluidTank.getFluid() : null;
        if (fluid != null) {
            return fluid.getFluid().getViscosity();
        }
        return 0;
    }

    public int getFluidTemperature() {
        int fluidTemp = 300;
        if (this.fluidTank != null) {
            FluidStack fluid = this.fluidTank.getFluid();
            fluidTemp = fluid != null ? fluid.getFluid().getTemperature(fluid) : fluidTemp;
        }
        return fluidTemp - 273;
    }

    public void fillWaterFromEnvironment() {
        boolean isRaining;
        IBlockState iblockstate;
        Material material;
        if (this.dataName != "basicCoolingSystem" || this.fluidTank == null) {
            return;
        }
        if (this.player.func_70090_H() && (material = (iblockstate = this.player.field_70170_p.func_180495_p(this.player.func_180425_c())).func_185904_a()) == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)iblockstate.func_177230_c());
            this.player.field_70170_p.func_180501_a(this.player.func_180425_c(), Blocks.field_150350_a.func_176223_P(), 11);
            this.player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            this.fluidTank.fill(new FluidStack(fluid, Math.min(this.getMaxFluidLevel() - this.getFluidLevel(), 1000)), false);
        }
        boolean bl = isRaining = this.player.field_70170_p.getBiomeForCoordsBody(this.player.func_180425_c()).func_76727_i() > 0.0f && (this.player.field_70170_p.func_72896_J() || this.player.field_70170_p.func_72911_I());
        if (isRaining && this.player.field_70170_p.func_175710_j(this.player.func_180425_c().func_177982_a(0, 1, 0)) && this.player.field_70170_p.func_82737_E() % 5L == 0L && this.getFluidLevel() < this.getMaxFluidLevel()) {
            this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, Math.min(this.getMaxFluidLevel() - this.getFluidLevel(), 100)), false);
        }
    }
}

