/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER = new ResourceLocation("voicechat", "textures/gui/voice_activation_slider.png");
    private static final ITextComponent NO_ACTIVATION = new TextComponentTranslation("message.voicechat.voice_activation.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    private double micValue;

    public VoiceActivationSlider(int id, int x, int y, int width, int height) {
        super(id, x, y, width, height, Utils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.updateMessage();
    }

    @Override
    public void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
        mc.func_110434_K().func_110577_a(SLIDER);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = (int)((double)(this.func_146117_b() - 2) * this.micValue);
        this.func_73729_b(this.field_146128_h + 1, this.field_146129_i + 1, 0, 0, width, 18);
    }

    @Override
    protected void updateMessage() {
        long db = Math.round(Utils.percToDb(this.value));
        TextComponentTranslation component = new TextComponentTranslation("message.voicechat.voice_activation", new Object[]{db});
        if (db >= -10L) {
            component.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        this.field_146126_j = component.func_150254_d();
    }

    @Nullable
    public ITextComponent getHoverText() {
        if (this.value >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(Utils.percToDb(this.value)).save();
    }

    @Override
    public void onMicValue(double percentage) {
        this.micValue = percentage;
    }

    public boolean isHovered() {
        return this.field_146123_n;
    }
}

