/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocxnetdriver.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration != null) {
            return;
        }
        configuration = new Configuration(configFile, null);
        ConfigurationHandler.loadConfiguration();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("ocxnetdriver")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        Settings.ignoreEnergyTransferLimits = ConfigurationHandler.configuration.getBoolean("ignoreEnergyTransferLimits", "General", true, "Ignore the insertion/extraction limits when transferring energy");
        Settings.maxEnergyTransferTicksPerCall = ConfigurationHandler.configuration.getInt("maxEnergyTransferTicksPerCall", "General", Integer.MAX_VALUE, 1, Integer.MAX_VALUE, "How many energy transfer ticks to perform during a single call");
        Settings.useRelativePositions = ConfigurationHandler.configuration.getBoolean("useRelativePositions", "General", true, "Whether to use positions relative to the controller instead of absolute positions");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        result.add((IConfigElement)new ConfigElement(configuration.getCategory("General")));
        return result;
    }

    public static class Settings {
        private static boolean ignoreEnergyTransferLimits;
        private static int maxEnergyTransferTicksPerCall;
        private static boolean useRelativePositions;

        public static boolean ignoreEnergyTransferLimits() {
            return ignoreEnergyTransferLimits;
        }

        public static int getMaxEnergyTransferTicksPerCall() {
            return maxEnergyTransferTicksPerCall;
        }

        public static boolean useRelativePositions() {
            return useRelativePositions;
        }
    }
}

