/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.components.BlockColorComponent;
import appeng.bootstrap.components.StateMapperComponent;
import appeng.bootstrap.components.TesrComponent;
import appeng.client.render.model.AutoRotatingModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class BlockRendering
implements IBlockRendering,
ISelectiveResourceReloadListener {
    @SideOnly(value=Side.CLIENT)
    private BiFunction<ModelResourceLocation, IBakedModel, IBakedModel> modelCustomizer;
    @SideOnly(value=Side.CLIENT)
    private IBlockColor blockColor;
    @SideOnly(value=Side.CLIENT)
    private TileEntitySpecialRenderer<?> tesr;
    @SideOnly(value=Side.CLIENT)
    private IStateMapper stateMapper;
    @SideOnly(value=Side.CLIENT)
    private final Map<String, IModel> builtInModels = new HashMap<String, IModel>();
    @SideOnly(value=Side.CLIENT)
    private final List<IResourceManagerReloadListener> reloads = new ArrayList<IResourceManagerReloadListener>();

    BlockRendering() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering modelCustomizer(BiFunction<ModelResourceLocation, IBakedModel, IBakedModel> customizer) {
        this.modelCustomizer = customizer;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering blockColor(IBlockColor blockColor) {
        this.blockColor = blockColor;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering tesr(TileEntitySpecialRenderer<?> tesr) {
        this.tesr = tesr;
        return this;
    }

    @Override
    public IBlockRendering builtInModel(String name, IModel model) {
        this.builtInModels.put(name, model);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering stateMapper(IStateMapper mapper) {
        this.stateMapper = mapper;
        return this;
    }

    void apply(FeatureFactory factory, Block block, Class<?> tileEntityClass) {
        if (this.tesr != null) {
            if (tileEntityClass == null) {
                throw new IllegalStateException("Tried to register a TESR for " + block + " even though no tile entity has been specified.");
            }
            factory.addBootstrapComponent(new TesrComponent(tileEntityClass, this.tesr));
        }
        if (this.modelCustomizer != null) {
            factory.addModelOverride(block.getRegistryName().func_110623_a(), this.modelCustomizer);
        } else if (block instanceof AEBaseTileBlock) {
            factory.addModelOverride(block.getRegistryName().func_110623_a(), (l, m) -> {
                AutoRotatingModel model = new AutoRotatingModel((IBakedModel)m);
                this.reloads.add(model);
                return model;
            });
        }
        this.builtInModels.forEach(factory::addBuiltInModel);
        if (this.blockColor != null) {
            factory.addBootstrapComponent(new BlockColorComponent(block, this.blockColor));
        }
        if (this.stateMapper != null) {
            factory.addBootstrapComponent(new StateMapperComponent(block, this.stateMapper));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS)) {
            this.reloads.forEach(listener -> listener.func_110549_a(resourceManager));
        }
    }
}

