/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.util.Platform;
import gregtech.api.items.metaitem.MetaItem;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class NonBlockingItems {
    public static Map<String, Object2ObjectOpenHashMap<Item, IntSet>> NON_BLOCKING_MAP = new HashMap<String, Object2ObjectOpenHashMap<Item, IntSet>>();
    public static NonBlockingItems INSTANCE = new NonBlockingItems();

    private NonBlockingItems() {
        String[] strings = AEConfig.instance().getNonBlockingItems();
        String[] modids = new String[]{};
        for (String s : strings) {
            if (s.startsWith("[") && s.endsWith("]")) {
                modids = s.substring(1, s.length() - 1).split("\\|");
                continue;
            }
            for (String modid : modids) {
                if (!Platform.isModLoaded(modid)) continue;
                NON_BLOCKING_MAP.putIfAbsent(modid, (Object2ObjectOpenHashMap<Item, IntSet>)new Object2ObjectOpenHashMap());
                String[] ModItemMeta = s.split(":");
                if (ModItemMeta.length < 2 || ModItemMeta.length > 3) {
                    AELog.error("Invalid non blocking item entry: " + s, new Object[0]);
                    continue;
                }
                if (ModItemMeta[0].equals("gregtech") && Platform.GTLoaded) {
                    boolean found = false;
                    for (MetaItem metaItem : MetaItem.getMetaItems()) {
                        ItemStack itemStack2;
                        MetaItem.MetaValueItem metaItem2 = metaItem.getItem(ModItemMeta[1]);
                        if (metaItem.getItem(ModItemMeta[1]) != null) {
                            found = true;
                            itemStack2 = metaItem2.getStackForm();
                            NON_BLOCKING_MAP.get(modid).putIfAbsent((Object)itemStack2.func_77973_b(), (Object)new IntOpenHashSet());
                            NON_BLOCKING_MAP.get(modid).computeIfPresent((Object)itemStack2.func_77973_b(), (item, intSet) -> {
                                intSet.add(itemStack2.func_77952_i());
                                return intSet;
                            });
                            continue;
                        }
                        itemStack2 = GameRegistry.makeItemStack((String)(ModItemMeta[0] + ":" + ModItemMeta[1]), (int)(ModItemMeta.length == 3 ? Integer.parseInt(ModItemMeta[2]) : 0), (int)1, null);
                        if (itemStack2.func_190926_b()) continue;
                        NON_BLOCKING_MAP.get(modid).putIfAbsent((Object)itemStack2.func_77973_b(), (Object)new IntOpenHashSet());
                        NON_BLOCKING_MAP.get(modid).computeIfPresent((Object)itemStack2.func_77973_b(), (item, intSet) -> {
                            intSet.add(itemStack2.func_77952_i());
                            return intSet;
                        });
                    }
                    if (found) continue;
                    AELog.error("Item not found on nonBlocking config: " + s, new Object[0]);
                    continue;
                }
                if (ModItemMeta[0].equals("ore")) {
                    OreDictionary.getOres((String)ModItemMeta[1]).forEach(itemStack -> {
                        NON_BLOCKING_MAP.get(modid).putIfAbsent((Object)itemStack.func_77973_b(), (Object)new IntOpenHashSet());
                        NON_BLOCKING_MAP.get(modid).computeIfPresent((Object)itemStack.func_77973_b(), (item, intSet) -> {
                            intSet.add(itemStack.func_77952_i());
                            return intSet;
                        });
                    });
                    continue;
                }
                ItemStack itemStack3 = GameRegistry.makeItemStack((String)(ModItemMeta[0] + ":" + ModItemMeta[1]), (int)(ModItemMeta.length == 3 ? Integer.parseInt(ModItemMeta[2]) : 0), (int)1, null);
                if (!itemStack3.func_190926_b()) {
                    NON_BLOCKING_MAP.get(modid).putIfAbsent((Object)itemStack3.func_77973_b(), (Object)new IntOpenHashSet());
                    NON_BLOCKING_MAP.get(modid).computeIfPresent((Object)itemStack3.func_77973_b(), (item, intSet) -> {
                        intSet.add(itemStack3.func_77952_i());
                        return intSet;
                    });
                    continue;
                }
                AELog.error("Item not found on nonBlocking config: " + s, new Object[0]);
            }
        }
    }

    public Map<String, Object2ObjectOpenHashMap<Item, IntSet>> getMap() {
        return NON_BLOCKING_MAP;
    }

    public void init() {
    }
}

