/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.helpers.IContainerCraftingPacket;
import appeng.integration.modules.jei.CraftableCallBack;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class JEIMissingItem
implements IRecipeTransferError {
    private boolean errored;
    public long lastUpdate;
    private final List<Integer> craftableSlots = new ArrayList<Integer>();
    private final List<Integer> foundSlots = new ArrayList<Integer>();
    IItemList<IAEItemStack> available = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    IItemList<IAEItemStack> used = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();

    JEIMissingItem(Container container, @Nonnull IRecipeLayout recipeLayout) {
        if (container instanceof ContainerMEMonitorable) {
            IItemList<IAEItemStack> ir = ((ContainerMEMonitorable)container).items;
            IItemList<IAEItemStack> available = this.mergeInventories(ir, (ContainerMEMonitorable)container);
            this.errored = false;
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new CraftableCallBack(container, available));
            IItemList<IAEItemStack> used = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
            for (IGuiIngredient i : recipeLayout.getItemStacks().getGuiIngredients().values()) {
                boolean found = false;
                if (!i.isInput() || i.getAllIngredients().isEmpty()) continue;
                List allIngredients = i.getAllIngredients();
                for (Object allIngredient : allIngredients) {
                    if (!(allIngredient instanceof ItemStack)) continue;
                    ItemStack stack = (ItemStack)allIngredient;
                    if (!stack.func_190926_b()) {
                        AEItemStack search = AEItemStack.fromItemStack(stack);
                        if (stack.func_77973_b().func_77645_m() || Platform.isGTDamageableItem(stack.func_77973_b())) {
                            Collection<IAEItemStack> fuzzy = available.findFuzzy(search, FuzzyMode.IGNORE_ALL);
                            if (fuzzy.isEmpty()) continue;
                            for (IAEItemStack itemStack : fuzzy) {
                                if (itemStack.getStackSize() <= 0L || Platform.isGTDamageableItem(stack.func_77973_b()) && stack.func_77960_j() != itemStack.getDefinition().func_77960_j()) continue;
                                found = true;
                                used.add((IAEItemStack)itemStack.copy().setStackSize(1L));
                            }
                            continue;
                        }
                        IAEItemStack ext = available.findPrecise(search);
                        if (ext == null) continue;
                        IAEItemStack usedStack = used.findPrecise(ext);
                        if (ext.getStackSize() <= 0L || usedStack != null && ext.getStackSize() <= usedStack.getStackSize()) continue;
                        used.add((IAEItemStack)ext.copy().setStackSize(1L));
                        found = true;
                        continue;
                    }
                    found = true;
                }
                if (found) continue;
                this.errored = true;
                break;
            }
        }
    }

    @Nonnull
    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.USER_FACING;
    }

    public void showError(Minecraft minecraft, int mouseX, int mouseY, @Nonnull IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        Container c = minecraft.field_71439_g.field_71070_bA;
        if (c instanceof ContainerMEMonitorable) {
            ContainerMEMonitorable container = (ContainerMEMonitorable)c;
            IItemList<IAEItemStack> ir = ((ContainerMEMonitorable)c).items;
            boolean found = false;
            boolean foundAny = false;
            boolean craftable = false;
            boolean foundAnyCraftable = false;
            int currentSlot = 0;
            this.errored = false;
            if (System.currentTimeMillis() - this.lastUpdate <= 1000L) {
                for (IGuiIngredient i : recipeLayout.getItemStacks().getGuiIngredients().values()) {
                    if (i.isInput() && !this.foundSlots.contains(currentSlot)) {
                        if (this.craftableSlots.contains(currentSlot)) {
                            i.drawHighlight(minecraft, new Color(0.0f, 0.0f, 1.0f, 0.4f), recipeX, recipeY);
                        } else {
                            i.drawHighlight(minecraft, new Color(1.0f, 0.0f, 0.0f, 0.4f), recipeX, recipeY);
                        }
                    }
                    ++currentSlot;
                }
                return;
            }
            this.lastUpdate = System.currentTimeMillis();
            this.available = this.mergeInventories(ir, container);
            this.foundSlots.clear();
            this.craftableSlots.clear();
            this.used.resetStatus();
            for (IGuiIngredient i : recipeLayout.getItemStacks().getGuiIngredients().values()) {
                found = false;
                craftable = false;
                IItemList<IAEItemStack> valid = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                if (i.isInput()) {
                    List allIngredients = i.getAllIngredients();
                    for (Object allIngredient : allIngredients) {
                        if (!(allIngredient instanceof ItemStack)) continue;
                        ItemStack stack = (ItemStack)allIngredient;
                        if (!stack.func_190926_b()) {
                            AEItemStack search = AEItemStack.fromItemStack(stack);
                            if (stack.func_77973_b().func_77645_m() || Platform.isGTDamageableItem(stack.func_77973_b())) {
                                Collection<IAEItemStack> fuzzy = this.available.findFuzzy(search, FuzzyMode.IGNORE_ALL);
                                if (fuzzy.isEmpty()) continue;
                                for (IAEItemStack itemStack : fuzzy) {
                                    if (itemStack.getStackSize() > 0L) {
                                        if (Platform.isGTDamageableItem(stack.func_77973_b()) && stack.func_77960_j() != itemStack.getDefinition().func_77960_j()) continue;
                                        found = true;
                                        this.used.add((IAEItemStack)itemStack.copy().setStackSize(1L));
                                        valid.add((IAEItemStack)itemStack.copy().setStackSize(1L));
                                        continue;
                                    }
                                    if (!itemStack.isCraftable()) continue;
                                    craftable = true;
                                }
                                continue;
                            }
                            IAEItemStack ext = this.available.findPrecise(search);
                            if (ext == null) continue;
                            IAEItemStack usedStack = this.used.findPrecise(ext);
                            if (ext.getStackSize() > 0L && (usedStack == null || usedStack.getStackSize() < ext.getStackSize())) {
                                this.used.add((IAEItemStack)ext.copy().setStackSize(1L));
                                if (craftable) {
                                    valid.resetStatus();
                                }
                                valid.add((IAEItemStack)ext.copy().setStackSize(1L));
                                found = true;
                                continue;
                            }
                            if (!ext.isCraftable()) continue;
                            valid.add((IAEItemStack)ext.copy().setStackSize(1L));
                            craftable = true;
                            continue;
                        }
                        found = true;
                    }
                    if (i.getAllIngredients().isEmpty()) {
                        ++currentSlot;
                        continue;
                    }
                    ArrayList validStacks = new ArrayList();
                    valid.forEach(v -> {
                        if (v.getStackSize() > 0L) {
                            ItemStack validStack = v.createItemStack();
                            validStack.func_190920_e(1);
                            validStacks.add(validStack);
                        }
                    });
                    if (!found) {
                        if (craftable) {
                            i.drawHighlight(minecraft, new Color(0.0f, 0.0f, 1.0f, 0.4f), recipeX, recipeY);
                            this.craftableSlots.add(currentSlot);
                            recipeLayout.getItemStacks().set(currentSlot, validStacks);
                            foundAnyCraftable = true;
                        } else {
                            i.drawHighlight(minecraft, new Color(1.0f, 0.0f, 0.0f, 0.4f), recipeX, recipeY);
                        }
                        this.errored = true;
                    } else {
                        foundAny = true;
                        this.foundSlots.add(currentSlot);
                        recipeLayout.getItemStacks().set(currentSlot, validStacks);
                    }
                }
                ++currentSlot;
            }
            RecipeTransferButton b = ((RecipeLayout)recipeLayout).getRecipeTransferButton();
            if (b != null) {
                ArrayList<String> tooltipLines = new ArrayList<String>();
                b.init(c, (EntityPlayer)minecraft.field_71439_g);
                if (this.errored && foundAny) {
                    tooltipLines.add(I18n.func_74838_a((String)"gui.tooltips.appliedenergistics2.PartialTransfer"));
                    b.field_146124_l = true;
                    b.field_146125_m = true;
                }
                if (this.errored) {
                    tooltipLines.add(I18n.func_74838_a((String)"gui.tooltips.appliedenergistics2.MissingItem"));
                }
                if (foundAnyCraftable) {
                    tooltipLines.add(I18n.func_74838_a((String)"gui.tooltips.appliedenergistics2.CraftableItem"));
                }
                TooltipRenderer.drawHoveringText((Minecraft)minecraft, tooltipLines, (int)mouseX, (int)mouseY);
            }
        }
    }

    IItemList<IAEItemStack> mergeInventories(IItemList<IAEItemStack> repo, ContainerMEMonitorable containerCraftingTerm) {
        IItemList<IAEItemStack> itemList = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        for (IAEItemStack i : repo) {
            itemList.addStorage(i);
        }
        PlayerMainInvWrapper invWrapper = new PlayerMainInvWrapper(containerCraftingTerm.getPlayerInv());
        for (int i = 0; i < invWrapper.getSlots(); ++i) {
            itemList.addStorage(AEItemStack.fromItemStack(invWrapper.getStackInSlot(i)));
        }
        if (containerCraftingTerm instanceof IContainerCraftingPacket) {
            IItemHandler itemHandler = ((IContainerCraftingPacket)((Object)containerCraftingTerm)).getInventoryByName("crafting");
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                itemList.addStorage(AEItemStack.fromItemStack(itemHandler.getStackInSlot(i)));
            }
        }
        return itemList;
    }

    public boolean errored() {
        return this.errored;
    }
}

