/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.networking.BlockCableBus;
import appeng.block.paint.BlockPaint;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.BaseActionSource;
import appeng.tile.misc.TilePaint;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ToolColorApplicator
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack>,
IItemGroup,
IBlockTool,
IMouseWheelItem {
    private static final double POWER_PER_USE = 100.0;
    private static final Map<Integer, AEColor> ORE_TO_COLOR = new HashMap<Integer, AEColor>();

    public ToolColorApplicator() {
        super(AEConfig.instance().getColorApplicatorBattery());
    }

    public EnumActionResult func_180614_a(EntityPlayer p, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.onItemUse(p.func_184586_b(hand), p, w, pos, hand, side, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer p, EnumHand hand) {
        ItemStack stack = p.func_184586_b(hand);
        if (p.func_70093_af()) {
            if (!w.field_72995_K) {
                this.cycleColors(stack, this.getColor(stack), 1);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack is, EntityPlayer p, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (p.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        Block blk = w.func_180495_p(pos).func_177230_c();
        ItemStack paintBall = this.getColor(is);
        IMEInventory<IAEItemStack> inv = this.getInventory(is);
        if (inv != null) {
            AEColor color;
            IAEItemStack option = inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.SIMULATE, new BaseActionSource());
            if (option != null) {
                paintBall = option.createItemStack();
                paintBall.func_190920_e(1);
            } else {
                paintBall = ItemStack.field_190927_a;
            }
            if (!Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
                return EnumActionResult.FAIL;
            }
            if (!paintBall.func_190926_b() && paintBall.func_77973_b() instanceof ItemSnowball) {
                TileEntity te = w.func_175625_s(pos);
                if (te instanceof IColorableTile && this.getAECurrentPower(is) > 100.0 && ((IColorableTile)te).getColor() != AEColor.TRANSPARENT && ((IColorableTile)te).recolourBlock(side, AEColor.TRANSPARENT, p)) {
                    this.consumeItem(is, paintBall, false);
                    return EnumActionResult.SUCCESS;
                }
                Block testBlk = w.func_180495_p(pos.func_177972_a(side)).func_177230_c();
                TileEntity painted = w.func_175625_s(pos.func_177972_a(side));
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof BlockPaint && painted instanceof TilePaint) {
                    this.consumeItem(is, paintBall, false);
                    ((TilePaint)painted).cleanSide(side.func_176734_d());
                    return EnumActionResult.SUCCESS;
                }
            } else if (!paintBall.func_190926_b() && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.TRANSPARENT && this.recolourBlock(blk, side, w, pos, side, color, p)) {
                this.consumeItem(is, paintBall, false);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean consumeColor(ItemStack applicator, AEColor color, boolean simulate) {
        IMEInventory<IAEItemStack> inv = this.getInventory(applicator);
        if (inv == null) {
            return false;
        }
        ItemStack paintItem = null;
        for (IAEItemStack what : inv.getAvailableItems(this.getChannel().createList())) {
            ItemStack def = what.createItemStack();
            def.func_190920_e(1);
            if (this.getColorFromItem(def) != color) continue;
            paintItem = def;
        }
        if (paintItem != null) {
            return this.consumeItem(applicator, paintItem, simulate);
        }
        return false;
    }

    public boolean consumeItem(ItemStack applicator, ItemStack paintItem, boolean simulate) {
        boolean success;
        IMEInventory<IAEItemStack> inv = this.getInventory(applicator);
        if (inv == null) {
            return false;
        }
        Actionable mode = simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        boolean bl = success = inv.extractItems(AEItemStack.fromItemStack(paintItem), mode, new BaseActionSource()) != null && this.extractAEPower(applicator, 100.0, mode) >= 100.0;
        if (success && !simulate && ItemStack.func_77989_b((ItemStack)paintItem, (ItemStack)this.getColor(applicator)) && inv.extractItems(AEItemStack.fromItemStack(paintItem), Actionable.SIMULATE, new BaseActionSource()) == null) {
            this.setColor(applicator, ItemStack.field_190927_a);
        }
        return success;
    }

    public boolean setActiveColor(ItemStack applicator, @Nullable AEColor color) {
        if (color == null) {
            this.setColor(applicator, ItemStack.field_190927_a);
            return true;
        }
        IMEInventory<IAEItemStack> inv = this.getInventory(applicator);
        if (inv == null) {
            return false;
        }
        for (IAEItemStack stack : inv.getAvailableItems(this.getChannel().createList())) {
            ItemStack def = stack.getDefinition();
            if (this.getColorFromItem(def) != color) continue;
            this.setColor(applicator, def);
            return true;
        }
        return false;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String extra = GuiText.Empty.getLocal();
        AEColor selected = this.getActiveColor(par1ItemStack);
        if (selected != null && Platform.isClient()) {
            extra = Platform.gui_localize(selected.unlocalizedName);
        }
        return super.func_77653_i(par1ItemStack) + " - " + extra;
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    private AEColor getColorFromItem(ItemStack paintBall) {
        int[] id;
        if (paintBall.func_190926_b()) {
            return null;
        }
        if (paintBall.func_77973_b() instanceof ItemSnowball) {
            return AEColor.TRANSPARENT;
        }
        Item item = paintBall.func_77973_b();
        if (item instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)item;
            return ipb.getColor(paintBall);
        }
        for (int oreID : id = OreDictionary.getOreIDs((ItemStack)paintBall)) {
            if (!ORE_TO_COLOR.containsKey(oreID)) continue;
            return ORE_TO_COLOR.get(oreID);
        }
        return null;
    }

    private IMEInventory<IAEItemStack> getInventory(ItemStack stack) {
        return AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
    }

    public ItemStack getColor(ItemStack is) {
        NBTTagCompound color;
        ItemStack oldColor;
        NBTTagCompound c = is.func_77978_p();
        if (c != null && c.func_74764_b("color") && !(oldColor = new ItemStack(color = c.func_74775_l("color"))).func_190926_b()) {
            return oldColor;
        }
        return this.findNextColor(is, ItemStack.field_190927_a, 0);
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = ItemStack.field_190927_a;
        IMEInventory<IAEItemStack> inv = this.getInventory(is);
        if (inv != null) {
            IItemList<IAEItemStack> itemList = inv.getAvailableItems(this.getChannel().createList());
            if (anchor.func_190926_b()) {
                IAEItemStack firstItem = itemList.getFirstItem();
                if (firstItem != null) {
                    newColor = firstItem.asItemStackRepresentation();
                }
            } else {
                LinkedList<IAEItemStack> list = new LinkedList<IAEItemStack>();
                for (IAEItemStack i : itemList) {
                    list.add(i);
                }
                Collections.sort(list, Comparator.comparingInt(IAEItemStack::getItemDamage));
                if (list.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                IAEItemStack where = (IAEItemStack)list.getFirst();
                for (int cycles = 1 + list.size(); cycles > 0 && !where.equals(anchor); --cycles) {
                    list.addLast((IAEItemStack)list.removeFirst());
                    where = (IAEItemStack)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((IAEItemStack)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((IAEItemStack)list.removeLast());
                }
                return ((IAEItemStack)list.get(0)).asItemStackRepresentation();
            }
        }
        if (!newColor.func_190926_b()) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(ItemStack is, ItemStack newColor) {
        NBTTagCompound data = Platform.openNbtData(is);
        if (newColor.func_190926_b()) {
            data.func_82580_o("color");
        } else {
            NBTTagCompound color = new NBTTagCompound();
            newColor.func_77955_b(color);
            data.func_74782_a("color", (NBTBase)color);
        }
    }

    private boolean recolourBlock(Block blk, EnumFacing side, World w, BlockPos pos, EnumFacing orientation, AEColor newColor, EntityPlayer p) {
        IBlockState state = w.func_180495_p(pos);
        if (blk instanceof BlockColored) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a);
            if (newColor.dye == color) {
                return false;
            }
            return w.func_175656_a(pos, state.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150359_w) {
            return w.func_175656_a(pos, Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150399_cn) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlass.field_176547_a);
            if (newColor.dye == color) {
                return false;
            }
            return w.func_175656_a(pos, state.func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150410_aZ) {
            return w.func_175656_a(pos, Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150397_co) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a);
            if (newColor.dye == color) {
                return false;
            }
            return w.func_175656_a(pos, state.func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150405_ch) {
            return w.func_175656_a(pos, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)newColor.dye));
        }
        if (blk instanceof BlockCableBus) {
            return ((BlockCableBus)blk).recolorBlock(w, pos, side, newColor.dye, p);
        }
        return blk.recolorBlock(w, pos, side, newColor.dye);
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall.func_190926_b()) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        AEApi.instance().client().addCellInformation(cdi, lines);
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        if (requestedAddition != null) {
            int[] id;
            for (int x : id = OreDictionary.getOreIDs((ItemStack)requestedAddition.getDefinition())) {
                if (!ORE_TO_COLOR.containsKey(x)) continue;
                return false;
            }
            if (requestedAddition.getItem() instanceof ItemSnowball) {
                return false;
            }
            return !(requestedAddition.getItem() instanceof ItemPaintBall) || requestedAddition.getItemDamage() >= 20;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    static {
        for (AEColor color : AEColor.VALID_COLORS) {
            String dyeName = color.dye.func_176762_d();
            String oreDictName = "dye" + WordUtils.capitalize((String)dyeName);
            int oreDictId = OreDictionary.getOreID((String)oreDictName);
            ORE_TO_COLOR.put(oreDictId, color);
        }
    }
}

