/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEPartLocation;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PartPlacement {
    public static EnumActionResult place(ItemStack held, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand, World world) {
        if (!(held.func_77973_b() instanceof IPartItem)) {
            return EnumActionResult.PASS;
        }
        Placement placement = PartPlacement.getPartPlacement(player, world, held, pos, side);
        if (placement == null) {
            return EnumActionResult.FAIL;
        }
        IPart part = PartPlacement.placePart(player, world, held, placement.pos(), placement.side(), hand);
        if (part == null) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            if (player != null && !player.func_184812_l_()) {
                held.func_190918_g(1);
                if (held.func_190916_E() == 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        player.func_184609_a(hand);
        return EnumActionResult.PASS;
    }

    public static IPart placePart(@Nullable EntityPlayer player, World world, ItemStack partItem, BlockPos pos, EnumFacing side, EnumHand hand) {
        IPartHost host = AEApi.instance().partHelper().getOrPlacePartHost(world, pos, false, player);
        if (host == null) {
            return null;
        }
        AEPartLocation location = host.addPart(partItem, AEPartLocation.fromFacing(side), player, hand);
        IPart part = host.getPart(location);
        if (part == null) {
            if (host.isEmpty()) {
                host.cleanup();
            }
            return null;
        }
        IBlockState multiPartState = AEApi.instance().definitions().blocks().multiPart().maybeBlock().get().func_176223_P();
        SoundType soundType = multiPartState.func_177230_c().getSoundType(multiPartState, world, pos, null);
        world.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        return part;
    }

    @Nullable
    public static Placement getPartPlacement(@Nullable EntityPlayer player, World world, ItemStack partStack, BlockPos pos, EnumFacing side) {
        if (PartPlacement.canPlacePartOnBlock(player, world, partStack, pos, side)) {
            return new Placement(pos, side);
        }
        if (PartPlacement.canPlacePartOnBlock(player, world, partStack, pos = pos.func_177972_a(side), side = side.func_176734_d())) {
            return new Placement(pos, side);
        }
        return null;
    }

    public static boolean canPlacePartOnBlock(@Nullable EntityPlayer player, World world, ItemStack partStack, BlockPos pos, EnumFacing side) {
        IPartHost host = AEApi.instance().partHelper().getPartHost(world, pos);
        if (host == null && !AEApi.instance().partHelper().canPlacePartHost(world, pos, player)) {
            return false;
        }
        return host == null || host.canAddPart(partStack, AEPartLocation.fromFacing(side));
    }

    public static final class Placement {
        private final BlockPos pos;
        private final EnumFacing side;

        public Placement(BlockPos pos, EnumFacing side) {
            this.pos = pos;
            this.side = side;
        }

        public String toString() {
            return "Placement[" + "pos=" + this.pos + "," + "side=" + this.side + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Placement)arg0).pos, this.pos)) {
                return false;
            }
            return Objects.equals(((Placement)arg0).side, this.side);
            {
            }
        }

        public BlockPos pos() {
            return this.pos;
        }

        public EnumFacing side() {
            return this.side;
        }
    }
}

