/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.PartBasicState;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public abstract class PartP2PTunnel<T extends PartP2PTunnel>
extends PartBasicState {
    private final TunnelCollection type = new TunnelCollection(null, this.getClass());
    private boolean output;
    private short freq;

    public PartP2PTunnel(ItemStack is) {
        super(is);
    }

    public TunnelCollection<T> getCollection(Collection<PartP2PTunnel> collection, Class<? extends PartP2PTunnel> c) {
        if (this.type.matches(c)) {
            this.type.setSource(collection);
            return this.type;
        }
        return null;
    }

    public TunnelCollection<T> getInputs() throws GridAccessException {
        if (this.getProxy().isActive() && this.getFrequency() != 0) {
            return this.getProxy().getP2P().getInputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    public TunnelCollection<T> getOutputs() throws GridAccessException {
        if (this.getProxy().isActive()) {
            return this.getProxy().getP2P().getOutputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setOutput(data.func_74767_n("output"));
        this.freq = data.func_74765_d("freq");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("output", this.isOutput());
        data.func_74777_a("freq", this.getFrequency());
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        short oldf = this.freq;
        this.freq = data.readShort();
        return c || oldf != this.freq;
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeShort((int)this.getFrequency());
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.onTunnelNetworkChange();
        super.chanRender(c);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onTunnelNetworkChange();
        super.powerRender(c);
    }

    @Override
    @MENetworkEventSubscribe
    public void bootingRender(MENetworkBootingStatusChange bs) {
        this.onTunnelNetworkChange();
        super.bootingRender(bs);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        boolean pasteAsOutput = true;
        ItemStack is = player.func_184586_b(hand);
        if (is.func_190926_b()) {
            pasteAsOutput = false;
            is = player.func_184592_cb();
        }
        try {
            boolean hasPerms = this.getProxy().getSecurity().hasPermission(player, SecurityPermissions.BUILD);
            if (!hasPerms) {
                return false;
            }
        }
        catch (GridAccessException e) {
            return false;
        }
        TunnelType tt = AEApi.instance().registries().p2pTunnel().getTunnelTypeByItem(is);
        if (!is.func_190926_b() && is.func_77973_b() instanceof IMemoryCard) {
            Object testPart;
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            NBTTagCompound data = mc.getData(is);
            ItemStack newType = new ItemStack(data);
            short freq = data.func_74765_d("freq");
            if (!newType.func_190926_b() && newType.func_77973_b() instanceof IPartItem && (testPart = ((IPartItem)newType.func_77973_b()).createPartFromItemStack(newType)) instanceof PartP2PTunnel) {
                try {
                    this.getProxy().getP2P().removeTunnel(this, this.getFrequency());
                }
                catch (GridAccessException e) {
                    e.printStackTrace();
                }
                this.getHost().removePart(this.getSide(), true);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    if (pasteAsOutput) {
                        newTunnel.setOutput(true);
                    }
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, freq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (tt != null) {
            ItemStack newType;
            IParts parts = AEApi.instance().definitions().parts();
            switch (tt) {
                case LIGHT: {
                    newType = parts.p2PTunnelLight().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case FE_POWER: {
                    newType = parts.p2PTunnelFE().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case GTEU_POWER: {
                    newType = parts.p2PTunnelGTEU().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case FLUID: {
                    newType = parts.p2PTunnelFluids().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case IC2_POWER: {
                    newType = parts.p2PTunnelEU().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case ITEM: {
                    newType = parts.p2PTunnelItems().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case ME: {
                    newType = parts.p2PTunnelME().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case REDSTONE: {
                    newType = parts.p2PTunnelRedstone().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                default: {
                    newType = ItemStack.field_190927_a;
                }
            }
            if (!newType.func_190926_b() && !ItemStack.func_179545_c((ItemStack)newType, (ItemStack)this.getItemStack())) {
                boolean oldOutput = this.isOutput();
                short myFreq = this.getFrequency();
                try {
                    this.getProxy().getP2P().removeTunnel(this, this.getFrequency());
                }
                catch (GridAccessException e) {
                    e.printStackTrace();
                }
                this.getHost().removePart(this.getSide(), false);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(oldOutput);
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, myFreq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        try {
            boolean hasPerms = this.getProxy().getSecurity().hasPermission(player, SecurityPermissions.BUILD);
            if (!hasPerms) {
                return false;
            }
        }
        catch (GridAccessException e) {
            return false;
        }
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!is.func_190926_b() && is.func_77973_b() instanceof IMemoryCard) {
            if (Platform.isClient()) {
                return true;
            }
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            NBTTagCompound data = mc.getData(is);
            short storedFrequency = data.func_74765_d("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            try {
                if (needsNewFrequency) {
                    newFreq = this.getProxy().getP2P().newFrequency();
                    ItemStack newType = this.getHost().getPart(this.getSide()).getItemStack(PartItemStack.WRENCH);
                    try {
                        this.getProxy().getP2P().removeTunnel(this, this.getFrequency());
                    }
                    catch (GridAccessException e) {
                        e.printStackTrace();
                    }
                    this.getHost().removePart(this.getSide(), false);
                    AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                    IPart newBus = this.getHost().getPart(dir);
                    if (newBus instanceof PartP2PTunnel) {
                        PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                        newTunnel.setOutput(false);
                        newTunnel.getProxy().getP2P().updateFreq(newTunnel, newFreq);
                        newTunnel.onTunnelNetworkChange();
                    }
                } else {
                    this.getProxy().getP2P().updateFreq(this, newFreq);
                    this.onTunnelNetworkChange();
                }
                Platform.notifyBlocksOfNeighbors(this.getTile().func_145831_w(), this.getTile().func_174877_v());
            }
            catch (GridAccessException newType) {
                // empty catch block
            }
            this.onTunnelConfigChange();
            ItemStack p2pItem = this.getItemStack(PartItemStack.WRENCH);
            String type = p2pItem.func_77977_a();
            p2pItem.func_77955_b(data);
            if (needsNewFrequency) {
                data.func_74777_a("freq", newFreq);
            } else {
                data.func_74777_a("freq", this.getFrequency());
            }
            AEColor[] colors = Platform.p2p().toColors(this.getFrequency());
            int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
            data.func_74783_a("colorCode", colorCode);
            mc.setMemoryCardContents(is, type + ".name", data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        try {
            this.getProxy().getEnergy().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public short getFrequency() {
        return this.freq;
    }

    public void setFrequency(short freq) {
        short oldf = this.freq;
        this.freq = freq;
        if (oldf != this.freq) {
            this.getHost().markForUpdate();
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
    }

    @Override
    public Long getRenderFlag() {
        long ret = Short.toUnsignedLong(this.getFrequency());
        if (this.isActive() && this.isPowered()) {
            ret |= 0x10000L;
        }
        return ret;
    }
}

