/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline.transformers;

import appeng.thirdparty.codechicken.lib.math.InterpHelper;
import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineElementFactory;
import appeng.thirdparty.codechicken.lib.model.pipeline.QuadTransformer;

public class QuadReInterpolator
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadReInterpolator> FACTORY = QuadReInterpolator::new;
    private final Quad interpCache = new Quad();
    private final InterpHelper interpHelper = new InterpHelper();

    QuadReInterpolator() {
    }

    @Override
    public void reset(CachedFormat format) {
        super.reset(format);
        this.interpCache.reset(format);
    }

    @Override
    public void setInputQuad(Quad quad) {
        super.setInputQuad(quad);
        quad.resetInterp(this.interpHelper, quad.orientation.ordinal() >> 1);
    }

    @Override
    public boolean transform() {
        int s = this.quad.orientation.ordinal() >> 1;
        if (this.format.hasColor || this.format.hasUV || this.format.hasLightMap) {
            this.interpCache.copyFrom(this.quad);
            this.interpHelper.setup();
            for (Quad.Vertex v : this.quad.vertices) {
                this.interpHelper.locate(v.dx(s), v.dy(s));
                if (this.format.hasColor) {
                    v.interpColorFrom(this.interpHelper, this.interpCache.vertices);
                }
                if (this.format.hasUV) {
                    v.interpUVFrom(this.interpHelper, this.interpCache.vertices);
                }
                if (!this.format.hasLightMap) continue;
                v.interpLightMapFrom(this.interpHelper, this.interpCache.vertices);
            }
        }
        return true;
    }
}

