/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.tile.inventory.AppEngInternalOversizedInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.item.AEItemStack;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class AppEngNetworkInventory
extends AppEngInternalOversizedInventory {
    private final Supplier<IStorageGrid> supplier;
    private final IActionSource source;

    public AppEngNetworkInventory(Supplier<IStorageGrid> networkSupplier, IActionSource source, IAEAppEngInventory inventory, int size, int maxStack) {
        super(inventory, size, maxStack);
        this.supplier = networkSupplier;
        this.source = source;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        IStorageGrid storage = this.supplier.get();
        if (storage != null) {
            int originAmt = stack.func_190916_E();
            IMEMonitor<IAEItemStack> dest = storage.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IAEItemStack overflow = dest.injectItems(AEItemStack.fromItemStack(stack), simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.source);
            if (overflow != null && overflow.getStackSize() == (long)originAmt) {
                return super.insertItem(slot, stack, simulate);
            }
            if (overflow != null) {
                return overflow.createItemStack();
            }
            return ItemStack.field_190927_a;
        }
        return super.insertItem(slot, stack, simulate);
    }
}

