/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.com.naef.jnlua;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.repack.com.naef.jnlua.Converter;
import li.cil.repack.com.naef.jnlua.JavaFunction;
import li.cil.repack.com.naef.jnlua.LuaState;
import li.cil.repack.com.naef.jnlua.LuaType;
import li.cil.repack.com.naef.jnlua.LuaValueProxy;
import li.cil.repack.com.naef.jnlua.TypedJavaObject;
import li.cil.repack.com.naef.jnlua.util.AbstractTableList;
import li.cil.repack.com.naef.jnlua.util.AbstractTableMap;

public class DefaultConverter
implements Converter {
    private static final boolean RAW_BYTE_ARRAY = false;
    private static final DefaultConverter INSTANCE = new DefaultConverter();
    private static final Map<Class<?>, Integer> BOOLEAN_DISTANCE_MAP = new HashMap();
    private static final Map<Class<?>, Integer> NUMBER_DISTANCE_MAP;
    private static final Map<Class<?>, Integer> STRING_DISTANCE_MAP;
    private static final Map<Class<?>, Integer> FUNCTION_DISTANCE_MAP;
    private static final Map<Class<?>, LuaValueConverter<?>> LUA_VALUE_CONVERTERS;
    private static final Map<Class<?>, JavaObjectConverter<?>> JAVA_OBJECT_CONVERTERS;

    public static boolean isTypeSupported(Class<?> clazz) {
        return JAVA_OBJECT_CONVERTERS.get(clazz) != null;
    }

    public static DefaultConverter getInstance() {
        return INSTANCE;
    }

    private DefaultConverter() {
    }

    @Override
    public int getTypeDistance(LuaState luaState, int index, Class<?> formalType) {
        LuaType luaType = luaState.type(index);
        if (luaType == null) {
            return Integer.MAX_VALUE;
        }
        if (formalType == Void.TYPE) {
            return Integer.MAX_VALUE;
        }
        if (formalType == LuaValueProxy.class) {
            return 0;
        }
        switch (luaType) {
            case NIL: {
                return 1;
            }
            case BOOLEAN: {
                Integer distance = BOOLEAN_DISTANCE_MAP.get(formalType);
                if (distance == null) break;
                return distance;
            }
            case NUMBER: {
                Integer distance = NUMBER_DISTANCE_MAP.get(formalType);
                if (distance == null) break;
                return distance;
            }
            case STRING: {
                Integer distance = STRING_DISTANCE_MAP.get(formalType);
                if (distance == null) break;
                return distance;
            }
            case TABLE: {
                if (formalType == Map.class || formalType == List.class || formalType.isArray()) {
                    return 1;
                }
                if (formalType != Object.class) break;
                return 2;
            }
            case FUNCTION: {
                Integer distance;
                if (!luaState.isJavaFunction(index) || (distance = FUNCTION_DISTANCE_MAP.get(formalType)) == null) break;
                return distance;
            }
            case USERDATA: {
                Class<?> type2;
                Object object = luaState.toJavaObjectRaw(index);
                if (object == null) break;
                if (object instanceof TypedJavaObject) {
                    TypedJavaObject typedJavaObject = (TypedJavaObject)object;
                    if (typedJavaObject.isStrong() && formalType.isAssignableFrom(typedJavaObject.getClass())) {
                        return 1;
                    }
                    type2 = typedJavaObject.getType();
                } else {
                    type2 = object.getClass();
                }
                if (!formalType.isAssignableFrom(type2)) break;
                return 1;
            }
        }
        if (formalType == Object.class) {
            return 0x7FFFFFFE;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T convertLuaValue(LuaState luaState, int index, Class<T> formalType) {
        LuaType luaType = luaState.type(index);
        if (luaType == null) {
            throw new IllegalArgumentException("undefined index: " + index);
        }
        if (formalType == Void.TYPE) {
            throw new ClassCastException(String.format("cannot convert %s to %s", luaState.typeName(index), formalType.getCanonicalName()));
        }
        if (formalType == LuaValueProxy.class) {
            return (T)luaState.getProxy(index);
        }
        switch (luaType) {
            case NIL: {
                return null;
            }
            case BOOLEAN: {
                LuaValueConverter<?> luaValueConverter = LUA_VALUE_CONVERTERS.get(formalType);
                if (luaValueConverter != null) {
                    return (T)luaValueConverter.convert(luaState, index);
                }
                if (formalType != Object.class) break;
                return (T)Boolean.valueOf(luaState.toBoolean(index));
            }
            case NUMBER: {
                LuaValueConverter<?> luaValueConverter = LUA_VALUE_CONVERTERS.get(formalType);
                if (luaValueConverter != null) {
                    return (T)luaValueConverter.convert(luaState, index);
                }
                if (formalType != Object.class) break;
                if (luaState.isInteger(index)) {
                    return (T)Long.valueOf(luaState.toInteger(index));
                }
                return (T)Double.valueOf(luaState.toNumber(index));
            }
            case STRING: {
                LuaValueConverter<?> luaValueConverter = LUA_VALUE_CONVERTERS.get(formalType);
                if (luaValueConverter != null) {
                    return (T)luaValueConverter.convert(luaState, index);
                }
                if (formalType != Object.class) break;
                byte[] result2 = luaState.toByteArray(index);
                String string = new String(result2, StandardCharsets.UTF_8);
                if (string.getBytes(StandardCharsets.UTF_8).length != result2.length) {
                    return (T)result2;
                }
                return (T)string;
            }
            case TABLE: {
                if (formalType == Map.class || formalType == Object.class) {
                    final LuaValueProxy luaValueProxy = luaState.getProxy(index);
                    return (T)new AbstractTableMap<Object>(){

                        @Override
                        protected Object convertKey(int index) {
                            return this.getLuaState().toJavaObject(index, Object.class);
                        }

                        @Override
                        public LuaState getLuaState() {
                            return luaValueProxy.getLuaState();
                        }

                        @Override
                        public void pushValue() {
                            luaValueProxy.pushValue();
                        }
                    };
                }
                if (formalType == List.class) {
                    final LuaValueProxy luaValueProxy = luaState.getProxy(index);
                    return (T)new AbstractTableList(){

                        @Override
                        public LuaState getLuaState() {
                            return luaValueProxy.getLuaState();
                        }

                        @Override
                        public void pushValue() {
                            luaValueProxy.pushValue();
                        }
                    };
                }
                if (!formalType.isArray()) break;
                int length = luaState.rawLen(index);
                Class<?> componentType = formalType.getComponentType();
                Object array = Array.newInstance(formalType.getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    luaState.rawGet(index, i + 1);
                    try {
                        Array.set(array, i, this.convertLuaValue(luaState, -1, componentType));
                        continue;
                    }
                    finally {
                        luaState.pop(1);
                    }
                }
                return (T)array;
            }
            case FUNCTION: {
                if (!luaState.isJavaFunction(index) || formalType != JavaFunction.class && formalType != Object.class) break;
                return (T)luaState.toJavaFunction(index);
            }
            case USERDATA: {
                Object object = luaState.toJavaObjectRaw(index);
                if (object == null) break;
                if (object instanceof TypedJavaObject) {
                    TypedJavaObject typedJavaObject = (TypedJavaObject)object;
                    if (typedJavaObject.isStrong() && formalType.isAssignableFrom(typedJavaObject.getClass())) {
                        return (T)typedJavaObject;
                    }
                    return (T)((TypedJavaObject)object).getObject();
                }
                return (T)object;
            }
        }
        if (formalType == Object.class) {
            return (T)luaState.getProxy(index);
        }
        throw new ClassCastException(String.format("cannot convert %s to %s", luaState.typeName(index), formalType.getCanonicalName()));
    }

    @Override
    public void convertJavaObject(LuaState luaState, Object object) {
        if (object == null) {
            luaState.pushNil();
            return;
        }
        JavaObjectConverter<?> javaObjectConverter = JAVA_OBJECT_CONVERTERS.get(object.getClass());
        if (javaObjectConverter != null) {
            javaObjectConverter.convert(luaState, object);
            return;
        }
        if (object instanceof JavaFunction) {
            luaState.pushJavaFunction((JavaFunction)object);
            return;
        }
        if (object instanceof LuaValueProxy) {
            LuaValueProxy luaValueProxy = (LuaValueProxy)object;
            if (!luaValueProxy.getLuaState().equals(luaState)) {
                throw new IllegalArgumentException("Lua value proxy is from a different Lua state");
            }
            luaValueProxy.pushValue();
            return;
        }
        luaState.pushJavaObjectRaw(object);
    }

    static {
        BOOLEAN_DISTANCE_MAP.put(Boolean.class, 1);
        BOOLEAN_DISTANCE_MAP.put(Boolean.TYPE, 1);
        BOOLEAN_DISTANCE_MAP.put(Object.class, 2);
        NUMBER_DISTANCE_MAP = new HashMap();
        NUMBER_DISTANCE_MAP.put(Byte.class, 1);
        NUMBER_DISTANCE_MAP.put(Byte.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(Short.class, 1);
        NUMBER_DISTANCE_MAP.put(Short.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(Integer.class, 1);
        NUMBER_DISTANCE_MAP.put(Integer.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(Long.class, 1);
        NUMBER_DISTANCE_MAP.put(Long.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(Float.class, 1);
        NUMBER_DISTANCE_MAP.put(Float.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(Double.class, 1);
        NUMBER_DISTANCE_MAP.put(Double.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(BigInteger.class, 1);
        NUMBER_DISTANCE_MAP.put(BigDecimal.class, 1);
        NUMBER_DISTANCE_MAP.put(Character.class, 1);
        NUMBER_DISTANCE_MAP.put(Character.TYPE, 1);
        NUMBER_DISTANCE_MAP.put(Object.class, 2);
        NUMBER_DISTANCE_MAP.put(String.class, 3);
        NUMBER_DISTANCE_MAP.put(byte[].class, 3);
        STRING_DISTANCE_MAP = new HashMap();
        STRING_DISTANCE_MAP.put(String.class, 1);
        STRING_DISTANCE_MAP.put(byte[].class, 1);
        STRING_DISTANCE_MAP.put(Object.class, 2);
        STRING_DISTANCE_MAP.put(Byte.class, 3);
        STRING_DISTANCE_MAP.put(Byte.TYPE, 3);
        STRING_DISTANCE_MAP.put(Short.class, 3);
        STRING_DISTANCE_MAP.put(Short.TYPE, 3);
        STRING_DISTANCE_MAP.put(Integer.class, 3);
        STRING_DISTANCE_MAP.put(Integer.TYPE, 3);
        STRING_DISTANCE_MAP.put(Long.class, 3);
        STRING_DISTANCE_MAP.put(Long.TYPE, 3);
        STRING_DISTANCE_MAP.put(Float.class, 3);
        STRING_DISTANCE_MAP.put(Float.TYPE, 3);
        STRING_DISTANCE_MAP.put(Double.class, 3);
        STRING_DISTANCE_MAP.put(Double.TYPE, 3);
        STRING_DISTANCE_MAP.put(BigInteger.class, 3);
        STRING_DISTANCE_MAP.put(BigDecimal.class, 3);
        STRING_DISTANCE_MAP.put(Character.class, 3);
        STRING_DISTANCE_MAP.put(Character.TYPE, 3);
        FUNCTION_DISTANCE_MAP = new HashMap();
        FUNCTION_DISTANCE_MAP.put(JavaFunction.class, 1);
        FUNCTION_DISTANCE_MAP.put(Object.class, 2);
        LUA_VALUE_CONVERTERS = new HashMap();
        Object booleanConverter = (luaState, index) -> luaState.toBoolean(index);
        LUA_VALUE_CONVERTERS.put(Boolean.class, (LuaValueConverter<?>)booleanConverter);
        LUA_VALUE_CONVERTERS.put(Boolean.TYPE, (LuaValueConverter<?>)booleanConverter);
        LuaValueConverter<Byte> byteConverter = (luaState, index) -> (byte)luaState.toInteger(index);
        LUA_VALUE_CONVERTERS.put(Byte.class, byteConverter);
        LUA_VALUE_CONVERTERS.put(Byte.TYPE, byteConverter);
        LuaValueConverter<Short> shortConverter = (luaState, index) -> (short)luaState.toInteger(index);
        LUA_VALUE_CONVERTERS.put(Short.class, shortConverter);
        LUA_VALUE_CONVERTERS.put(Short.TYPE, shortConverter);
        LuaValueConverter<Integer> integerConverter = (luaState, index) -> (int)luaState.toInteger(index);
        LUA_VALUE_CONVERTERS.put(Integer.class, integerConverter);
        LUA_VALUE_CONVERTERS.put(Integer.TYPE, integerConverter);
        LuaValueConverter<Long> longConverter = (luaState, index) -> luaState.toInteger(index);
        LUA_VALUE_CONVERTERS.put(Long.class, longConverter);
        LUA_VALUE_CONVERTERS.put(Long.TYPE, longConverter);
        LuaValueConverter<Float> floatConverter = (luaState, index) -> Float.valueOf((float)luaState.toNumber(index));
        LUA_VALUE_CONVERTERS.put(Float.class, floatConverter);
        LUA_VALUE_CONVERTERS.put(Float.TYPE, floatConverter);
        LuaValueConverter<Double> doubleConverter = (luaState, index) -> luaState.toNumber(index);
        LUA_VALUE_CONVERTERS.put(Double.class, doubleConverter);
        LUA_VALUE_CONVERTERS.put(Double.TYPE, doubleConverter);
        LuaValueConverter<BigInteger> bigIntegerConverter = (luaState, index) -> BigDecimal.valueOf(luaState.toNumber(index)).setScale(0, 6).toBigInteger();
        LUA_VALUE_CONVERTERS.put(BigInteger.class, bigIntegerConverter);
        LuaValueConverter<BigDecimal> bigDecimalConverter = (luaState, index) -> BigDecimal.valueOf(luaState.toNumber(index));
        LUA_VALUE_CONVERTERS.put(BigDecimal.class, bigDecimalConverter);
        LuaValueConverter<Character> characterConverter = (luaState, index) -> Character.valueOf((char)luaState.toInteger(index));
        LUA_VALUE_CONVERTERS.put(Character.class, characterConverter);
        LUA_VALUE_CONVERTERS.put(Character.TYPE, characterConverter);
        LuaValueConverter<String> stringConverter = (luaState, index) -> luaState.toString(index);
        LUA_VALUE_CONVERTERS.put(String.class, stringConverter);
        LuaValueConverter<byte[]> byteArrayConverter = (luaState, index) -> luaState.toByteArray(index);
        LUA_VALUE_CONVERTERS.put(byte[].class, byteArrayConverter);
        JAVA_OBJECT_CONVERTERS = new HashMap();
        booleanConverter = (luaState, booleanValue) -> luaState.pushBoolean((boolean)booleanValue);
        JAVA_OBJECT_CONVERTERS.put(Boolean.class, (JavaObjectConverter<?>)booleanConverter);
        JAVA_OBJECT_CONVERTERS.put(Boolean.TYPE, (JavaObjectConverter<?>)booleanConverter);
        JavaObjectConverter<Number> integerConverter2 = (luaState, number) -> luaState.pushInteger(number.longValue());
        JAVA_OBJECT_CONVERTERS.put(Byte.class, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Byte.TYPE, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Short.class, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Short.TYPE, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Integer.class, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Integer.TYPE, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Long.class, integerConverter2);
        JAVA_OBJECT_CONVERTERS.put(Long.TYPE, integerConverter2);
        JavaObjectConverter<Number> numberConverter = (luaState, number) -> luaState.pushNumber(number.doubleValue());
        JAVA_OBJECT_CONVERTERS.put(Float.class, numberConverter);
        JAVA_OBJECT_CONVERTERS.put(Float.TYPE, numberConverter);
        JAVA_OBJECT_CONVERTERS.put(Double.class, numberConverter);
        JAVA_OBJECT_CONVERTERS.put(Double.TYPE, numberConverter);
        JAVA_OBJECT_CONVERTERS.put(BigDecimal.class, numberConverter);
        JavaObjectConverter<BigInteger> bigIntegerConverter2 = (luaState, number) -> {
            try {
                luaState.pushInteger(number.longValueExact());
            }
            catch (ArithmeticException e) {
                luaState.pushNumber(number.doubleValue());
            }
        };
        JAVA_OBJECT_CONVERTERS.put(BigInteger.class, bigIntegerConverter2);
        JavaObjectConverter<Character> characterConverter2 = (luaState, character) -> luaState.pushInteger(character.charValue());
        JAVA_OBJECT_CONVERTERS.put(Character.class, characterConverter2);
        JAVA_OBJECT_CONVERTERS.put(Character.TYPE, characterConverter2);
        JavaObjectConverter<String> stringConverter2 = (luaState, string) -> luaState.pushString((String)string);
        JAVA_OBJECT_CONVERTERS.put(String.class, stringConverter2);
        JavaObjectConverter<byte[]> byteArrayConverter2 = (luaState, byteArray) -> luaState.pushByteArray((byte[])byteArray);
        JAVA_OBJECT_CONVERTERS.put(byte[].class, byteArrayConverter2);
    }

    @FunctionalInterface
    private static interface LuaValueConverter<T> {
        public T convert(LuaState var1, int var2);
    }

    @FunctionalInterface
    private static interface JavaObjectConverter<T> {
        public void convert(LuaState var1, T var2);
    }
}

