/*
 * Decompiled with CFR 0.152.
 */
package bq_rf.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.io.FloatSimpleIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelHBarFill;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import bq_rf.tasks.TaskRfCharge;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.vector.Vector4f;

public class PanelTaskCharge
extends CanvasEmpty {
    private static final DecimalFormat df = new DecimalFormat("0.##");
    private static final String[] suffixes = new String[]{"", "K", "M", "B", "T"};
    private final TaskRfCharge task;
    private PanelTextBox txtValue;
    private IValueIO<Float> barValue;
    private UUID uuid;
    private boolean flipFlop = false;

    public PanelTaskCharge(IGuiRect rect, TaskRfCharge task) {
        super(rect);
        this.task = task;
    }

    public void drawPanel(int mx, int my, float partialTick) {
        if (System.currentTimeMillis() / 500L % 2L == 0L != this.flipFlop) {
            this.flipFlop = !this.flipFlop;
            long progress = this.task.getUsersProgress(this.uuid);
            String strReq = this.formatRF(this.task.RF);
            String strPrg = this.formatRF(progress);
            float percent = (float)((double)progress / (double)this.task.RF);
            this.txtValue.setText(TextFormatting.BOLD + strPrg + " / " + strReq + " RF");
            this.barValue.writeValue((Object)Float.valueOf(percent));
        }
        super.drawPanel(mx, my, partialTick);
    }

    public void initPanel() {
        super.initPanel();
        Minecraft mc = Minecraft.func_71410_x();
        this.uuid = QuestingAPI.getQuestingUUID((EntityPlayer)mc.field_71439_g);
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -16, -32, 32, 32, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150451_bX))));
        long progress = this.task.getUsersProgress(this.uuid);
        String strReq = this.formatRF(this.task.RF);
        String strPrg = this.formatRF(progress);
        float percent = (float)((double)progress / (double)this.task.RF);
        PanelHBarFill fillBar = new PanelHBarFill((IGuiRect)new GuiTransform(new Vector4f(0.25f, 0.5f, 0.75f, 0.5f), new GuiPadding(0, 0, 0, -16), 0));
        fillBar.setFillColor((IGuiColor)new GuiColorStatic(-65536));
        this.barValue = new FloatSimpleIO(percent, 0.0f, 1.0f).setLerp(true, 0.01f);
        fillBar.setFillDriver(this.barValue);
        this.addPanel((IGuiPanel)fillBar);
        this.txtValue = new PanelTextBox((IGuiRect)new GuiTransform(new Vector4f(0.25f, 0.5f, 0.75f, 0.5f), new GuiPadding(0, 4, 0, -16), -1), TextFormatting.BOLD + strPrg + " / " + strReq + " RF").setAlignment(1);
        this.addPanel((IGuiPanel)this.txtValue);
    }

    private String formatRF(long value) {
        String s = "";
        double n = 1.0;
        for (int i = suffixes.length - 1; i >= 0; --i) {
            n = Math.pow(1000.0, i);
            if (!((double)Math.abs(value) >= n)) continue;
            s = suffixes[i];
            break;
        }
        return df.format((double)value / n) + s;
    }
}

