/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.GravisuitLang;

public class ItemToolAdvancedChainsaw
extends ItemElectricTool
implements IStaticTexturedItem {
    public static final ItemStack diamondAxe = new ItemStack(Items.field_151056_x);

    public ItemToolAdvancedChainsaw() {
        super(0.0f, 0.0f, Item.ToolMaterial.IRON);
        this.field_77865_bY = 4.0f;
        this.maxCharge = GravisuitConfig.powerValues.advancedChainsawStorage;
        this.transferLimit = GravisuitConfig.powerValues.advancedChainsawTransfer;
        this.operationEnergyCost = 100;
        this.tier = 2;
        this.field_77864_a = 24.0f;
        this.setHarvestLevel("axe", 3);
        this.setRegistryName("advancedchainsaw");
        if (Loader.isModLoaded((String)"gtc_expansion")) {
            this.setTranslationKey(GravisuitLang.advancedDiamondChainsaw);
        } else {
            this.setTranslationKey(GravisuitLang.advancedChainsaw);
        }
        this.func_77637_a(IC2.tabIC2);
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setMaxCharge(int storage) {
        this.maxCharge = storage;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.transferLimit = maxTransfer;
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (!tag.func_74767_n("noShear")) {
            tooltip.add(GravisuitLang.messageAdvancedChainsawNormal.getLocalized());
        } else if (tag.func_74767_n("noShear")) {
            tooltip.add(GravisuitLang.messageAdvancedChainsawNoShear.getLocalized());
        }
        if (!tag.func_74767_n("noTreeCutting")) {
            tooltip.add(GravisuitLang.messageAdvancedChainsawTreeCuttingOn.getLocalized());
        } else {
            tooltip.add(GravisuitLang.messageAdvancedChainsawTreeCuttingOff.getLocalized());
        }
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), GravisuitLang.advancedChainsawShearToggle.getLocalized()}));
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{GravisuitLang.gravisuitToggleCombo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(9), IC2.keyboard.getKeyName(2)}), GravisuitLang.advancedChainsawTreeCuttingToggle.getLocalized()}));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int i) {
        int id = Loader.isModLoaded((String)"gtc_expansion") ? 18 : 8;
        return Ic2Icons.getTextures((String)"gravisuit_items")[id];
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return diamondAxe.func_150998_b(state) || state.func_177230_c() == Blocks.field_150321_G;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return 1.0f;
        }
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151584_j && material != Material.field_151570_A && material != Material.field_151572_C && material != Material.field_151580_n ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase entity, EnumHand hand) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (!tag.func_74767_n("noShear")) {
            return Ic2Items.chainSaw.func_77973_b().func_111207_a(stack, playerIn, entity, hand);
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        Set<BlockPos> positions;
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        World worldIn = player.field_70170_p;
        if (!(player.func_70093_af() || tag.func_74767_n("noTreeCutting") || (positions = this.getTargetBlocks(worldIn, pos, player)).isEmpty())) {
            for (BlockPos pos2 : positions) {
                this.breakBlock(pos2, itemstack, worldIn, pos, player);
            }
        }
        if (!tag.func_74767_n("noShear")) {
            return Ic2Items.chainSaw.func_77973_b().onBlockStartBreak(itemstack, pos, player);
        }
        return false;
    }

    public Set<BlockPos> getTargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        BlockPos nextPos;
        IBlockState nextState;
        int i;
        HashSet<BlockPos> targetBlocks = new HashSet<BlockPos>();
        if (playerIn == null) {
            return new HashSet<BlockPos>();
        }
        RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
        if (raytrace == null || raytrace.field_178784_b == null) {
            return Collections.emptySet();
        }
        EnumFacing enumfacing = raytrace.field_178784_b;
        if (enumfacing == EnumFacing.DOWN) {
            return Collections.emptySet();
        }
        BlockPos left = this.left(enumfacing, pos);
        BlockPos leftback = this.back(enumfacing, left);
        BlockPos back = this.back(enumfacing, pos);
        BlockPos right = this.right(enumfacing, pos);
        BlockPos rightback = this.back(enumfacing, right);
        if (enumfacing != EnumFacing.UP && worldIn.func_180495_p(back).func_177230_c().isWood((IBlockAccess)worldIn, back)) {
            targetBlocks.add(back);
            for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = back.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                targetBlocks.add(nextPos);
            }
            if (worldIn.func_180495_p(left).func_177230_c().isWood((IBlockAccess)worldIn, left) && worldIn.func_180495_p(leftback).func_177230_c().isWood((IBlockAccess)worldIn, leftback)) {
                targetBlocks.add(left);
                targetBlocks.add(leftback);
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = left.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = leftback.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
            } else if (worldIn.func_180495_p(right).func_177230_c().isWood((IBlockAccess)worldIn, right) && worldIn.func_180495_p(rightback).func_177230_c().isWood((IBlockAccess)worldIn, rightback)) {
                targetBlocks.add(right);
                targetBlocks.add(rightback);
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = right.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = rightback.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
            }
        }
        if (worldIn.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)worldIn, pos)) {
            for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = pos.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                targetBlocks.add(nextPos);
            }
        }
        return targetBlocks;
    }

    public BlockPos left(EnumFacing facing, BlockPos old) {
        if (facing == EnumFacing.NORTH) {
            return old.func_177982_a(1, 0, 0);
        }
        if (facing == EnumFacing.WEST) {
            return old.func_177982_a(0, 0, -1);
        }
        if (facing == EnumFacing.SOUTH) {
            return old.func_177982_a(-1, 0, 0);
        }
        if (facing == EnumFacing.EAST) {
            return old.func_177982_a(0, 0, 1);
        }
        return old;
    }

    public BlockPos right(EnumFacing facing, BlockPos old) {
        if (facing == EnumFacing.NORTH) {
            return old.func_177982_a(-1, 0, 0);
        }
        if (facing == EnumFacing.WEST) {
            return old.func_177982_a(0, 0, 1);
        }
        if (facing == EnumFacing.SOUTH) {
            return old.func_177982_a(1, 0, 0);
        }
        if (facing == EnumFacing.EAST) {
            return old.func_177982_a(0, 0, -1);
        }
        return old;
    }

    public BlockPos back(EnumFacing facing, BlockPos old) {
        if (facing == EnumFacing.NORTH) {
            return old.func_177982_a(0, 0, 1);
        }
        if (facing == EnumFacing.WEST) {
            return old.func_177982_a(1, 0, 0);
        }
        if (facing == EnumFacing.SOUTH) {
            return old.func_177982_a(0, 0, -1);
        }
        if (facing == EnumFacing.EAST) {
            return old.func_177982_a(-1, 0, 0);
        }
        return old;
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos originalPos, BlockPos pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185903_a(playerIn, worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.func_180495_p(originalPos).func_185903_a(playerIn, worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }

    public boolean isTree(BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksSawed");
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public void breakBlock(BlockPos pos, ItemStack saw, World world, BlockPos oldPos, EntityPlayer player) {
        if (oldPos == pos) {
            return;
        }
        if (!ElectricItem.manager.canUse(saw, (double)this.getEnergyCost(saw))) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185887_b(world, pos) == -1.0f) {
            return;
        }
        ElectricItem.manager.use(saw, (double)this.getEnergyCost(saw), (EntityLivingBase)player);
        blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), saw);
        world.func_175698_g(pos);
        world.func_175713_t(pos);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (player.func_70093_af()) {
                if (tag.func_74767_n("noTreeCutting")) {
                    tag.func_74757_a("noTreeCutting", false);
                    IC2.platform.messagePlayer(player, TextFormatting.GREEN, GravisuitLang.messageAdvancedChainsawTreeCuttingOn);
                } else {
                    tag.func_74757_a("noTreeCutting", true);
                    IC2.platform.messagePlayer(player, TextFormatting.RED, GravisuitLang.messageAdvancedChainsawTreeCuttingOff);
                }
            } else if (tag.func_74767_n("noShear")) {
                tag.func_74757_a("noShear", false);
                IC2.platform.messagePlayer(player, TextFormatting.GREEN, GravisuitLang.messageAdvancedChainsawNormal);
            } else {
                tag.func_74757_a("noShear", true);
                IC2.platform.messagePlayer(player, TextFormatting.RED, GravisuitLang.messageAdvancedChainsawNoShear);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench instanceof EnchantmentDamage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return Ic2Items.chainSaw.func_77973_b().func_77644_a(stack, target, attacker);
    }
}

