/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import com.google.common.collect.ImmutableSet;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.GravisuitLang;

public class ItemToolAdvancedDiamondDrill
extends ItemElectricTool
implements IStaticTexturedItem,
IMiningDrill {
    static boolean gtcxLoaded = Loader.isModLoaded((String)"gtc_expansion");
    final ItemStack torch = new ItemStack(Blocks.field_150478_aa);

    public ItemToolAdvancedDiamondDrill() {
        super(0.0f, -3.0f, Item.ToolMaterial.DIAMOND);
        this.setRegistryName("advanceddrill");
        this.setTranslationKey(GravisuitLang.advancedDrill);
        this.field_77865_bY = 4.0f;
        this.maxCharge = GravisuitConfig.powerValues.advancedDrillStorage;
        this.transferLimit = GravisuitConfig.powerValues.advancedDrillTransfer;
        this.tier = 2;
        this.func_77637_a(IC2.tabIC2);
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setMaxCharge(int storage) {
        this.maxCharge = storage;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.transferLimit = maxTransfer;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            ToolMode toolMode = ToolMode.values()[nbt.func_74771_c("ToolModeDrill")];
            toolMode = toolMode.getNext();
            nbt.func_74774_a("ToolModeDrill", (byte)toolMode.ordinal());
            if (toolMode == ToolMode.NORMAL) {
                IC2.platform.messagePlayer(player, TextFormatting.AQUA, GravisuitLang.messageAdvancedDrillNormal);
            } else if (toolMode == ToolMode.LOWPOWER) {
                IC2.platform.messagePlayer(player, TextFormatting.GOLD, GravisuitLang.messageAdvancedDrillLowPower);
            } else if (toolMode == ToolMode.FINE) {
                IC2.platform.messagePlayer(player, TextFormatting.DARK_GREEN, GravisuitLang.messageAdvancedDrillFine);
            } else if (toolMode == ToolMode.BIGHOLES) {
                IC2.platform.messagePlayer(player, TextFormatting.LIGHT_PURPLE, GravisuitLang.messageAdvancedDrillBigHoles);
            } else if (toolMode == ToolMode.MEDIUMHOLES) {
                IC2.platform.messagePlayer(player, TextFormatting.BLUE, GravisuitLang.messageAdvancedDrillMediumHoles);
            } else {
                IC2.platform.messagePlayer(player, TextFormatting.DARK_PURPLE, GravisuitLang.messageAdvancedDrillTunnelHoles);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        ToolMode toolMode = ToolMode.values()[nbt.func_74771_c("ToolModeDrill")];
        if (toolMode == ToolMode.NORMAL) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.advancedDrillNormal}));
        } else if (toolMode == ToolMode.LOWPOWER) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.advancedDrillLowPower}));
        } else if (toolMode == ToolMode.FINE) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.advancedDrillFine}));
        } else if (toolMode == ToolMode.BIGHOLES) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.advancedDrillBigHoles}));
        } else if (toolMode == ToolMode.MEDIUMHOLES) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.advancedDrillMediumHoles}));
        } else if (toolMode == ToolMode.TUNNELHOLES) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.advancedDrillTunnelHoles}));
        }
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), GravisuitLang.multiModes.getLocalized()}));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int i) {
        return Ic2Icons.getTextures((String)"gravisuit_items")[7];
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        ToolMode toolMode = ToolMode.values()[nbt.func_74771_c("ToolModeDrill")];
        World worldIn = player.field_70170_p;
        if (!player.func_70093_af()) {
            if (toolMode == ToolMode.BIGHOLES) {
                for (BlockPos additionalPos : this.get3X3TargetBlocks(worldIn, pos, player)) {
                    this.breakBlock(additionalPos, worldIn, player, stack);
                }
            } else if (toolMode == ToolMode.MEDIUMHOLES) {
                for (BlockPos additionalPos : this.get2X3TargetBlocks(worldIn, pos, player)) {
                    this.breakBlock(additionalPos, worldIn, player, stack);
                }
            } else if (toolMode == ToolMode.TUNNELHOLES) {
                this.breakBlock(this.get1x2TargetBlock(worldIn, pos, player), worldIn, player, stack);
            }
        }
        return false;
    }

    public Set<BlockPos> get3X3TargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        HashSet<BlockPos> targetBlocks;
        block9: {
            EnumFacing enumfacing;
            block10: {
                block8: {
                    targetBlocks = new HashSet<BlockPos>();
                    if (playerIn == null) {
                        return new HashSet<BlockPos>();
                    }
                    RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
                    if (raytrace == null || raytrace.field_178784_b == null) {
                        return Collections.emptySet();
                    }
                    enumfacing = raytrace.field_178784_b;
                    if (enumfacing != EnumFacing.SOUTH && enumfacing != EnumFacing.NORTH) break block8;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            BlockPos newPos = pos.func_177982_a(i, j, 0);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                    }
                    break block9;
                }
                if (enumfacing != EnumFacing.EAST && enumfacing != EnumFacing.WEST) break block10;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(0, j, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
                break block9;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block9;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    BlockPos newPos = pos.func_177982_a(j, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    public Set<BlockPos> get2X3TargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        HashSet<BlockPos> targetBlocks;
        block25: {
            EnumFacing enumFacing2;
            EnumFacing enumfacing;
            block28: {
                block27: {
                    block26: {
                        block24: {
                            targetBlocks = new HashSet<BlockPos>();
                            if (playerIn == null) {
                                return new HashSet<BlockPos>();
                            }
                            RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
                            if (raytrace == null || raytrace.field_178784_b == null) {
                                return Collections.emptySet();
                            }
                            enumfacing = raytrace.field_178784_b;
                            enumFacing2 = playerIn.func_174811_aO();
                            if (enumfacing != EnumFacing.SOUTH) break block24;
                            for (int i = 0; i < 2; ++i) {
                                for (int j = -1; j < 2; ++j) {
                                    BlockPos newPos = pos.func_177982_a(i, j, 0);
                                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                                    targetBlocks.add(newPos);
                                }
                            }
                            break block25;
                        }
                        if (enumfacing != EnumFacing.NORTH) break block26;
                        for (int i = -1; i < 1; ++i) {
                            for (int j = -1; j < 2; ++j) {
                                BlockPos newPos = pos.func_177982_a(i, j, 0);
                                if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                                targetBlocks.add(newPos);
                            }
                        }
                        break block25;
                    }
                    if (enumfacing != EnumFacing.EAST) break block27;
                    for (int i = -1; i < 1; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            BlockPos newPos = pos.func_177982_a(0, j, i);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                    }
                    break block25;
                }
                if (enumfacing != EnumFacing.WEST) break block28;
                for (int i = 0; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(0, j, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
                break block25;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block25;
            if (enumFacing2 == EnumFacing.SOUTH) {
                for (int i = -1; i < 1; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(i, 0, j);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
            } else if (enumFacing2 == EnumFacing.NORTH) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(i, 0, j);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
            } else if (enumFacing2 == EnumFacing.EAST) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(j, 0, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
            } else {
                for (int i = -1; i < 1; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(j, 0, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
            }
        }
        return targetBlocks;
    }

    public BlockPos get1x2TargetBlock(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        if (playerIn == null) {
            return pos.func_177984_a();
        }
        RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
        if (raytrace == null || raytrace.field_178784_b == null) {
            return pos.func_177984_a();
        }
        EnumFacing enumfacing = raytrace.field_178784_b;
        EnumFacing enumFacing2 = playerIn.func_174811_aO();
        BlockPos newPos = pos.func_177984_a();
        if (enumfacing == EnumFacing.UP || enumfacing == EnumFacing.DOWN) {
            newPos = enumFacing2 == EnumFacing.EAST ? pos.func_177982_a(1, 0, 0) : (enumFacing2 == EnumFacing.WEST ? pos.func_177982_a(-1, 0, 0) : (enumFacing2 == EnumFacing.SOUTH ? pos.func_177982_a(0, 0, 1) : pos.func_177982_a(0, 0, -1)));
        }
        return newPos;
    }

    public void breakBlock(BlockPos pos, World world, EntityPlayer player, ItemStack drill) {
        IBlockState blockState = world.func_180495_p(pos);
        if (!ElectricItem.manager.canUse(drill, (double)this.getEnergyCost(drill))) {
            return;
        }
        ElectricItem.manager.use(drill, (double)this.getEnergyCost(drill), (EntityLivingBase)player);
        blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), drill);
        world.func_175698_g(pos);
        world.func_175713_t(pos);
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos originalPos, BlockPos pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185903_a(playerIn, worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.func_180495_p(originalPos).func_185903_a(playerIn, worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        if (!(toolClass.equals("pickaxe") || toolClass.equals("shovel") || toolClass.equals("scoop"))) {
            return -1;
        }
        return 3;
    }

    public int getEnergyCost(ItemStack stack) {
        return 160;
    }

    public float getMiningSpeed(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        if (!nbt.func_74764_b("ToolModeDrill")) {
            return 48.0f;
        }
        ToolMode toolMode = ToolMode.values()[nbt.func_74771_c("ToolModeDrill")];
        if (toolMode == ToolMode.NORMAL) {
            return 48.0f;
        }
        if (toolMode == ToolMode.LOWPOWER) {
            return 16.0f;
        }
        if (toolMode == ToolMode.FINE || toolMode == ToolMode.MEDIUMHOLES) {
            return 8.0f;
        }
        if (toolMode == ToolMode.BIGHOLES) {
            return 5.3f;
        }
        return 24.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"scoop");
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksDrilled");
        }
        if (ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            IC2.audioManager.playOnce((Object)entityLiving, Ic2Sounds.drillHard);
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.DIGGER;
    }

    public boolean isBasicDrill(ItemStack d) {
        return false;
    }

    public int getExtraSpeed(ItemStack d) {
        int pointBoost = this.getPointBoost(d);
        return 9 + pointBoost;
    }

    private int getPointBoost(ItemStack drill) {
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        return lvl <= 0 ? 0 : lvl * lvl + 1;
    }

    public int getExtraEnergyCost(ItemStack d) {
        int points = this.getEnergyChange(d);
        return Math.max(points, 0);
    }

    public int getEnergyChange(ItemStack drill) {
        int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        int unb = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)drill);
        int points = eff * eff + 1;
        return points -= unb * (unb + unb);
    }

    public void useDrill(ItemStack d) {
        ElectricItem.manager.use(d, (double)this.getEnergyCost(d), (EntityLivingBase)null);
    }

    public boolean canMine(ItemStack d) {
        return ElectricItem.manager.canUse(d, (double)this.getEnergyCost(d));
    }

    public boolean canMineBlock(ItemStack d, IBlockState state, IBlockAccess access, BlockPos pos) {
        return ForgeHooks.canToolHarvestBlock((IBlockAccess)access, (BlockPos)pos, (ItemStack)d);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!gtcxLoaded) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack stack = ItemStack.field_190927_a;
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        for (ItemStack stack1 : player.field_71071_by.field_70462_a) {
            if (stack1.func_77973_b() != this.torch.func_77973_b()) continue;
            stack = stack1;
            break;
        }
        if (!stack.func_190926_b() && player.func_175151_a(pos, facing, stack) && worldIn.func_190527_a(Blocks.field_150478_aa, pos, false, facing, (Entity)player)) {
            IBlockState state1 = Blocks.field_150478_aa.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, worldIn, pos, facing, hitX, hitY, hitZ, state1)) {
                state1 = worldIn.func_180495_p(pos);
                SoundType soundtype = state1.func_177230_c().getSoundType(state1, worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150478_aa) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            Blocks.field_150478_aa.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    public static enum ToolMode {
        NORMAL,
        LOWPOWER,
        FINE,
        BIGHOLES,
        MEDIUMHOLES,
        TUNNELHOLES;


        public ToolMode getNext() {
            if (this == NORMAL) {
                return LOWPOWER;
            }
            if (this == LOWPOWER) {
                return FINE;
            }
            if (this == FINE) {
                if (GravisuitConfig.enableAdvancedDrill3x3Mode) {
                    return BIGHOLES;
                }
                if (GravisuitConfig.enableAdvancedDrill2x3Mode) {
                    return MEDIUMHOLES;
                }
                if (GravisuitConfig.enableAdvancedDrill1x2Mode) {
                    return TUNNELHOLES;
                }
                return NORMAL;
            }
            if (this == BIGHOLES) {
                if (GravisuitConfig.enableAdvancedDrill2x3Mode) {
                    return MEDIUMHOLES;
                }
                if (GravisuitConfig.enableAdvancedDrill1x2Mode) {
                    return TUNNELHOLES;
                }
                return NORMAL;
            }
            if (this == MEDIUMHOLES) {
                if (GravisuitConfig.enableAdvancedDrill1x2Mode) {
                    return TUNNELHOLES;
                }
                return NORMAL;
            }
            return NORMAL;
        }
    }
}

