/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.base.TileNetworkList;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileComponentChunkLoader
implements ITileComponent {
    public TileEntityContainerBlock tileEntity;
    public ForgeChunkManager.Ticket chunkTicket;
    public Set<ChunkPos> chunkSet = new HashSet<ChunkPos>();
    public Coord4D prevCoord;

    public TileComponentChunkLoader(TileEntityContainerBlock tile) {
        this.tileEntity = tile;
        tile.components.add(this);
    }

    public void setTicket(ForgeChunkManager.Ticket t) {
        if (this.chunkTicket != t && this.chunkTicket != null && this.chunkTicket.world == this.tileEntity.func_145831_w()) {
            for (ChunkPos chunk : this.chunkTicket.getChunkList()) {
                if (!ForgeChunkManager.getPersistentChunksFor((World)this.tileEntity.func_145831_w()).keys().contains((Object)chunk)) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        this.chunkTicket = t;
    }

    public void release() {
        this.setTicket(null);
    }

    public void sortChunks() {
        if (this.chunkTicket != null) {
            for (ChunkPos chunk : this.chunkTicket.getChunkList()) {
                if (this.chunkSet.contains(chunk) || !ForgeChunkManager.getPersistentChunksFor((World)this.tileEntity.func_145831_w()).keys().contains((Object)chunk)) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
            for (ChunkPos chunk : this.chunkSet) {
                if (this.chunkTicket.getChunkList().contains((Object)chunk)) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
        }
    }

    public void refreshChunkSet() {
        IChunkLoader loader = (IChunkLoader)((Object)this.tileEntity);
        if (!this.chunkSet.equals(loader.getChunkSet())) {
            this.chunkSet = loader.getChunkSet();
            this.sortChunks();
        }
    }

    public void forceChunks(ForgeChunkManager.Ticket ticket) {
        this.setTicket(ticket);
        for (ChunkPos chunk : this.chunkSet) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
        }
    }

    public boolean canOperate() {
        return MekanismConfig.general.allowChunkloading && ((IUpgradeTile)((Object)this.tileEntity)).getComponent().getInstalledTypes().contains((Object)Upgrade.ANCHOR);
    }

    @Override
    public void tick() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            ForgeChunkManager.Ticket ticket;
            if (this.prevCoord == null || !this.prevCoord.equals(Coord4D.get(this.tileEntity))) {
                this.release();
                this.prevCoord = Coord4D.get(this.tileEntity);
            }
            if (!(this.chunkTicket == null || this.canOperate() && this.chunkTicket.world == this.tileEntity.func_145831_w())) {
                this.release();
            }
            this.refreshChunkSet();
            if (this.canOperate() && this.chunkTicket == null && (ticket = this.tileEntity instanceof ISecurityTile ? ForgeChunkManager.requestPlayerTicket((Object)Mekanism.instance, (String)MekanismUtils.getLastKnownUsername(((ISecurityTile)((Object)this.tileEntity)).getSecurity().getOwnerUUID()), (World)this.tileEntity.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL) : ForgeChunkManager.requestTicket((Object)Mekanism.instance, (World)this.tileEntity.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
                ticket.getModData().func_74768_a("x", this.tileEntity.func_174877_v().func_177958_n());
                ticket.getModData().func_74768_a("y", this.tileEntity.func_174877_v().func_177956_o());
                ticket.getModData().func_74768_a("z", this.tileEntity.func_174877_v().func_177952_p());
                this.forceChunks(ticket);
            }
        }
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.prevCoord = Coord4D.read(nbtTags.func_74775_l("prevCoord"));
        this.chunkSet.clear();
        NBTTagList list = nbtTags.func_150295_c("chunkSet", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            this.chunkSet.add(new ChunkPos(compound.func_74762_e("chunkX"), compound.func_74762_e("chunkZ")));
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        if (this.prevCoord != null) {
            nbtTags.func_74782_a("prevCoord", (NBTBase)this.prevCoord.write(new NBTTagCompound()));
        }
        NBTTagList list = new NBTTagList();
        for (ChunkPos pos : this.chunkSet) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("chunkX", pos.field_77276_a);
            compound.func_74768_a("chunkZ", pos.field_77275_b);
            list.func_74742_a((NBTBase)compound);
        }
        nbtTags.func_74782_a("chunkSet", (NBTBase)list);
    }

    @Override
    public void write(TileNetworkList data) {
    }

    @Override
    public void invalidate() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            this.release();
        }
    }
}

