/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.armor;

import c4.conarm.common.ConstructsRegistry;
import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorNBT;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import c4.conarm.lib.tinkering.ArmorTooltipBuilder;
import c4.conarm.lib.tinkering.TinkersArmor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IToolStationDisplay;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;

public abstract class ArmorCore
extends TinkersArmor
implements IToolStationDisplay {
    public static final int DEFAULT_MODIFIERS = 3;
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final String appearanceName;

    public ArmorCore(EntityEquipmentSlot slotIn, String appearanceName, PartMaterialType core) {
        super(slotIn, core, ArmorMaterialType.plating(ConstructsRegistry.armorPlate), ArmorMaterialType.trim(ConstructsRegistry.armorTrim));
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabTools);
        this.setNoRepair();
        this.appearanceName = appearanceName;
        ArmoryRegistry.addArmor(this, slotIn);
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getDurabilityStat((ItemStack)stack);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return super.showDurabilityBar(stack) && !ToolHelper.isBroken((ItemStack)stack);
    }

    @Override
    public String getAppearanceName() {
        return this.appearanceName;
    }

    public String getLocalizedAppearanceName() {
        return Util.translate((String)("appearance." + this.getAppearanceName() + ".name"), (Object[])new Object[0]);
    }

    public String getLocalizedToolName() {
        return Util.translate((String)(this.func_77658_a() + ".name"), (Object[])new Object[0]);
    }

    public String getLocalizedDescription() {
        return Util.translate((String)(this.func_77658_a() + ".desc"), (Object[])new Object[0]);
    }

    public List<String> getInformation(ItemStack stack) {
        return this.getInformation(stack, true);
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        ArmorTooltipBuilder.addDefense(info, stack);
        ArmorTooltipBuilder.addToughness(info, stack);
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public void getTooltip(ItemStack stack, List<String> tooltips) {
        if (ToolHelper.isBroken((ItemStack)stack)) {
            tooltips.add("" + TextFormatting.DARK_RED + TextFormatting.BOLD + this.getBrokenTooltip(stack));
        }
        super.getTooltip(stack, tooltips);
    }

    protected String getBrokenTooltip(ItemStack itemStack) {
        return Util.translate((String)"tooltip.tool.broken", (Object[])new Object[0]);
    }

    public void getTooltipComponents(ItemStack stack, List<String> tooltips) {
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack));
        List<PartMaterialType> component = this.getRequiredComponents();
        if (materials.size() < component.size()) {
            return;
        }
        for (int i = 0; i < component.size(); ++i) {
            IToolPart part;
            ItemStack partStack;
            PartMaterialType pmt = component.get(i);
            Material material = (Material)materials.get(i);
            Iterator partIter = pmt.getPossibleParts().iterator();
            if (!partIter.hasNext() || (partStack = (part = (IToolPart)partIter.next()).getItemstackWithMaterial(material)) == null) continue;
            tooltips.add(material.getTextColor() + TextFormatting.UNDERLINE + partStack.func_82833_r());
            HashSet usedTraits = Sets.newHashSet();
            for (IMaterialStats stats : material.getAllStats()) {
                if (!pmt.usesStat(stats.getIdentifier())) continue;
                tooltips.addAll(stats.getLocalizedInfo());
                for (ITrait trait : pmt.getApplicableTraitsForMaterial(material)) {
                    if (usedTraits.contains(trait)) continue;
                    tooltips.add(material.getTextColor() + trait.getLocalizedName());
                    usedTraits.add(trait);
                }
            }
            tooltips.add("");
        }
    }

    @Override
    protected int repairCustom(Material material, NonNullList<ItemStack> repairItems) {
        Optional matchOptional = RecipeMatch.of((Item)ConstructsRegistry.polishingKit).matches(repairItems);
        if (!matchOptional.isPresent()) {
            return 0;
        }
        RecipeMatch.Match match = (RecipeMatch.Match)matchOptional.get();
        for (ItemStack stacks : match.stacks) {
            if (ConstructsRegistry.polishingKit.getMaterial(stacks) == material) continue;
            return 0;
        }
        RecipeMatch.removeMatch(repairItems, (RecipeMatch.Match)match);
        CoreMaterialStats stats = (CoreMaterialStats)material.getStats(ArmorMaterialType.CORE);
        float durability = stats.durability * (float)match.amount * (float)ConstructsRegistry.polishingKit.getCost();
        return (int)(durability /= 144.0f);
    }

    public String getIdentifier() {
        return this.getRegistryName().func_110623_a();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        this.onUpdateTraits(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    private void onUpdateTraits(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
            if (trait == null) continue;
            trait.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return TagUtil.hasEnchantEffect((ItemStack)stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack));
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        for (int index : this.getRepairParts()) {
            if (index >= materials.size()) continue;
            nameMaterials.add(materials.get(index));
        }
        return Material.getCombinedItemName((String)super.func_77653_i(stack), (Collection)nameMaterials);
    }

    protected ArmorNBT buildDefaultTag(List<Material> materials, int slotIn) {
        ArmorNBT data = new ArmorNBT();
        if (materials.size() >= 2) {
            CoreMaterialStats core = (CoreMaterialStats)materials.get(0).getStatsOrUnknown(ArmorMaterialType.CORE);
            PlatesMaterialStats plating = (PlatesMaterialStats)materials.get(1).getStatsOrUnknown(ArmorMaterialType.PLATES);
            data.core(slotIn, core);
            if (materials.size() >= 3) {
                TrimMaterialStats trim = (TrimMaterialStats)materials.get(2).getStatsOrUnknown(ArmorMaterialType.TRIM);
                data.trim(slotIn, trim);
            }
            data.plating(slotIn, plating);
        }
        data.modifiers = 3;
        return data;
    }

    @Override
    public final NBTTagCompound buildTag(List<Material> materials) {
        return this.buildTagData(materials).get();
    }

    protected ArmorNBT buildTagData(List<Material> materials) {
        return this.buildDefaultTag(materials, this.field_77881_a.func_188454_b());
    }

    public void getTooltipDetailed(ItemStack stack, List<String> tooltips) {
        tooltips.addAll(this.getInformation(stack, false));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List<ItemStack>)subItems, new Material[0]);
        }
    }

    protected void addDefaultSubItems(List<ItemStack> subItems, Material ... fixedMaterials) {
        for (Material core : TinkerRegistry.getAllMaterials()) {
            ArrayList<Material> mats = new ArrayList<Material>(this.requiredComponents.length);
            for (int i = 0; i < this.requiredComponents.length; ++i) {
                if (fixedMaterials.length > i && fixedMaterials[i] != null && this.requiredComponents[i].isValidMaterial(fixedMaterials[i])) {
                    mats.add(fixedMaterials[i]);
                    continue;
                }
                mats.add(core);
            }
            ItemStack armor = this.buildItem(mats);
            if (!this.hasValidMaterials(armor)) continue;
            subItems.add(armor);
            if (Config.listAllMaterials) continue;
            break;
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack armor) {
        HashMultimap multimap = HashMultimap.create();
        if (!ToolHelper.isBroken((ItemStack)armor)) {
            if (slot == this.field_77881_a) {
                multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)ArmorHelper.getArmor(armor, slot.func_188454_b()), 0));
                multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", (double)ArmorHelper.getToughness(armor), 0));
            }
            NBTTagList traitsList = TagUtil.getTraitsTagList((ItemStack)armor);
            for (int i = 0; i < traitsList.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait((String)traitsList.func_150307_f(i));
                if (trait == null) continue;
                trait.getAttributeModifiers(slot, armor, (Multimap)multimap);
            }
        }
        return multimap;
    }
}

