/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseSubsystem;
import gcewing.sg.BaseTEChunkManager;
import gcewing.sg.DHDBlock;
import gcewing.sg.DHDFuelContainer;
import gcewing.sg.DHDTE;
import gcewing.sg.FeatureGeneration;
import gcewing.sg.FeatureUnderDesertPyramid;
import gcewing.sg.IIntegration;
import gcewing.sg.IrisEntity;
import gcewing.sg.NaquadahBlock;
import gcewing.sg.NaquadahOreBlock;
import gcewing.sg.NaquadahOreWorldGen;
import gcewing.sg.PowerContainer;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGBaseContainer;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGChannel;
import gcewing.sg.SGChevronUpgradeItem;
import gcewing.sg.SGChunkData;
import gcewing.sg.SGCraftClient;
import gcewing.sg.SGEntity;
import gcewing.sg.SGGui;
import gcewing.sg.SGIrisUpgradeItem;
import gcewing.sg.SGRingBlock;
import gcewing.sg.SGRingItem;
import gcewing.sg.SGTradeHandler;
import gcewing.sg.cc.CCIntegration;
import gcewing.sg.oc.OCIntegration;
import gcewing.sg.rf.RFIntegration;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="sgcraft", name="SG Craft", version="1.13.2", acceptableRemoteVersions="[1.13,1.14)", dependencies="after:opencomputers;after:ic2;after:computercraft", acceptedMinecraftVersions="[1.12.2]")
public class SGCraft
extends BaseMod<SGCraftClient> {
    public static final Material machineMaterial = new Material(MapColor.field_151668_h);
    public static SGCraft mod;
    public static SGChannel channel;
    public static BaseTEChunkManager chunkManager;
    public static SGBaseBlock sgBaseBlock;
    public static SGRingBlock sgRingBlock;
    public static DHDBlock sgControllerBlock;
    public static Block naquadahBlock;
    public static Block naquadahOre;
    public static Item naquadah;
    public static Item naquadahIngot;
    public static Item sgCoreCrystal;
    public static Item sgControllerCrystal;
    public static Item sgChevronUpgrade;
    public static Item sgIrisUpgrade;
    public static Item sgIrisBlade;
    public static Block ic2PowerUnit;
    public static Item ic2Capacitor;
    public static Block rfPowerUnit;
    public static boolean addOresToExistingWorlds;
    public static NaquadahOreWorldGen naquadahOreGenerator;
    public static BaseSubsystem ic2Integration;
    public static IIntegration ccIntegration;
    public static OCIntegration ocIntegration;
    public static RFIntegration rfIntegration;

    public SGCraft() {
        mod = this;
        this.creativeTab = new CreativeTabs("sgcraft:sgcraft"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)sgBaseBlock));
            }
        };
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        FMLCommonHandler.instance().bus().register((Object)this);
        rfIntegration = (RFIntegration)this.integrateWithMod("forge", "gcewing.sg.rf.RFIntegration");
        ic2Integration = this.integrateWithMod("ic2", "gcewing.sg.ic2.IC2Integration");
        ccIntegration = (CCIntegration)this.integrateWithMod("computercraft", "gcewing.sg.cc.CCIntegration");
        ocIntegration = (OCIntegration)this.integrateWithMod("opencomputers", "gcewing.sg.oc.OCIntegration");
        super.preInit(e);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        super.init(e);
        System.out.printf("SGCraft.init\n", new Object[0]);
        this.configure();
        channel = new SGChannel("sgcraft");
        chunkManager = new BaseTEChunkManager(this);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }

    @Override
    protected SGCraftClient initClient() {
        return new SGCraftClient(this);
    }

    @Override
    void configure() {
        DHDTE.configure(this.config);
        NaquadahOreWorldGen.configure(this.config);
        SGBaseBlock.configure(this.config);
        SGBaseTE.configure(this.config);
        FeatureGeneration.configure(this.config);
        addOresToExistingWorlds = this.config.getBoolean("options", "addOresToExistingWorlds", false);
    }

    @Override
    protected void registerOther() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @Override
    protected void registerBlocks() {
        sgRingBlock = this.newBlock("stargateRing", SGRingBlock.class, SGRingItem.class);
        sgBaseBlock = this.newBlock("stargateBase", SGBaseBlock.class);
        sgControllerBlock = this.newBlock("stargateController", DHDBlock.class);
        naquadahBlock = this.newBlock("naquadahBlock", NaquadahBlock.class);
        naquadahOre = this.newBlock("naquadahOre", NaquadahOreBlock.class);
    }

    @Override
    protected void registerItems() {
        naquadah = this.newItem("naquadah");
        naquadahIngot = this.newItem("naquadahIngot");
        sgCoreCrystal = this.newItem("sgCoreCrystal");
        sgControllerCrystal = this.newItem("sgControllerCrystal");
        sgChevronUpgrade = this.addItem(new SGChevronUpgradeItem(), "sgChevronUpgrade");
        sgIrisUpgrade = this.addItem(new SGIrisUpgradeItem(), "sgIrisUpgrade");
        sgIrisBlade = this.newItem("sgIrisBlade");
        if (SGCraft.isModLoaded("ic2") || !SGCraft.isModLoaded("thermalexpansion")) {
            ic2Capacitor = this.newItem("ic2Capacitor");
        }
    }

    public static boolean isValidStargateUpgrade(Item item) {
        return item == sgChevronUpgrade || item == sgIrisUpgrade;
    }

    @Override
    protected void registerOres() {
        this.addOre("oreNaquadah", naquadahOre);
        this.addOre("naquadah", naquadah);
        this.addOre("ingotNaquadahAlloy", naquadahIngot);
    }

    @Override
    protected void registerRecipes() {
        ItemStack chiselledSandstone = new ItemStack(Blocks.field_150322_A, 1, 1);
        ItemStack smoothSandstone = new ItemStack(Blocks.field_150322_A, 1, 2);
        ItemStack sgChevronBlock = new ItemStack((Block)sgRingBlock, 1, 1);
        ItemStack blueDye = new ItemStack(Items.field_151100_aR, 1, 4);
        ItemStack orangeDye = new ItemStack(Items.field_151100_aR, 1, 14);
        if (this.config.getBoolean("options", "allowCraftingNaquadah", false)) {
            this.newShapelessRecipe("naquada", naquadah, 1, Ingredient.func_193368_a((Item[])new Item[]{Items.field_151044_h, Items.field_151123_aH, Items.field_151065_br}));
        }
        this.newRecipe("sgringblock", (Block)sgRingBlock, 1, "CCC", "NNN", "SSS", Character.valueOf('S'), smoothSandstone, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), chiselledSandstone);
        this.newRecipe("sgcheveronblock", sgChevronBlock, "CgC", "NpN", "SrS", Character.valueOf('S'), smoothSandstone, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), chiselledSandstone, Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151079_bi);
        this.newRecipe("sgbaseblock", (Block)sgBaseBlock, 1, "CrC", "NeN", "ScS", Character.valueOf('S'), smoothSandstone, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), chiselledSandstone, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('c'), sgCoreCrystal);
        this.newRecipe("sgcontrollerblock", (Block)sgControllerBlock, 1, "bbb", "OpO", "OcO", Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('c'), sgControllerCrystal);
        this.newShapelessRecipe("naquadahingot", naquadahIngot, 1, Ingredient.func_193367_a((Item)Items.field_151042_j), Ingredient.func_193367_a((Item)naquadah));
        this.newRecipe("naquadahblock", naquadahBlock, 1, "NNN", "NNN", "NNN", Character.valueOf('N'), "ingotNaquadahAlloy");
        this.newRecipe("sgchevronupgrade", sgChevronUpgrade, 1, "g g", "pNp", "r r", Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151079_bi);
        this.newRecipe("naquadahingot_from_block", naquadahIngot, 9, "B", Character.valueOf('B'), naquadahBlock);
        this.newRecipe("sgirisblade", sgIrisBlade, 1, " ii", "ic ", "i  ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), new ItemStack(Items.field_151044_h, 1, 1));
        this.newRecipe("sgirisupgrade", sgIrisUpgrade, 1, "bbb", "brb", "bbb", Character.valueOf('b'), sgIrisBlade, Character.valueOf('r'), Items.field_151137_ax);
        if (this.config.getBoolean("options", "allowCraftingCrystals", false)) {
            this.newRecipe("sgcorecrystal", sgCoreCrystal, 1, "bbr", "rdb", "brb", Character.valueOf('b'), blueDye, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('d'), Items.field_151045_i);
            this.newRecipe("sgcontrollercrystal", sgControllerCrystal, 1, "roo", "odr", "oor", Character.valueOf('o'), orangeDye, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('d'), Items.field_151045_i);
        }
        if (!SGCraft.isModLoaded("ic2")) {
            this.addGenericCapacitorRecipe();
        }
    }

    protected void addGenericCapacitorRecipe() {
        this.newRecipe("ic2capacitor", ic2Capacitor, 1, "iii", "ppp", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), "paper");
    }

    @Override
    protected void registerContainers() {
        this.addContainer(SGGui.SGBase, SGBaseContainer.class);
        this.addContainer(SGGui.DHDFuel, DHDFuelContainer.class);
        this.addContainer(SGGui.PowerUnit, PowerContainer.class);
    }

    @Override
    protected void registerWorldGenerators() {
        if (this.config.getBoolean("options", "enableNaquadahOre", true)) {
            System.out.printf("SGCraft: Registering NaquadahOreWorldGen\n", new Object[0]);
            naquadahOreGenerator = new NaquadahOreWorldGen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)naquadahOreGenerator, (int)0);
        }
        MapGenStructureIO.func_143031_a(FeatureUnderDesertPyramid.class, (String)"SGCraft:FeatureUnderDesertPyramid");
    }

    @Override
    protected void registerVillagers() {
        VillagerRegistry.VillagerProfession tokraProfession = new VillagerRegistry.VillagerProfession("sgcraft:tokra", "sgcraft:textures/skins/tokra.png", "sgcraft:textures/skins/tokra.png");
        VillagerRegistry.VillagerCareer tokraCareer = new VillagerRegistry.VillagerCareer(tokraProfession, "sgcraft:tokra");
        tokraCareer.addTrade(1, new EntityVillager.ITradeList[]{new SGTradeHandler()});
        ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)tokraProfession);
    }

    @Override
    protected void registerEntities() {
        this.addEntity(IrisEntity.class, "Stargate Iris", SGEntity.Iris, 1000000, false);
    }

    @Override
    protected void registerSounds() {
        SGBaseTE.registerSounds(this);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load e) {
        Chunk chunk = e.getChunk();
        SGChunkData.onChunkLoad(e);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save e) {
        Chunk chunk = e.getChunk();
        SGChunkData.onChunkSave(e);
    }

    @SubscribeEvent
    public void onInitMapGen(InitMapGenEvent e) {
        FeatureGeneration.onInitMapGen(e);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        switch (e.phase) {
            case START: {
                for (BaseSubsystem om : this.subsystems) {
                    if (!(om instanceof IIntegration)) continue;
                    ((IIntegration)((Object)om)).onServerTick();
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        Chunk chunk = e.getChunk();
        if (!chunk.func_177412_p().field_72995_K) {
            for (Object obj : chunk.func_177434_r().values()) {
                if (!(obj instanceof SGBaseTE)) continue;
                SGBaseTE te = (SGBaseTE)obj;
                te.disconnect();
            }
        }
    }
}

