/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import java.io.IOException;
import java.util.EnumMap;
import javax.annotation.Nullable;
import mezz.jei.network.PacketHandler;
import mezz.jei.network.PacketIdClient;
import mezz.jei.network.packets.IPacketJeiHandler;
import mezz.jei.network.packets.PacketCheatPermission;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PacketHandlerClient
extends PacketHandler {
    public final EnumMap<PacketIdClient, IPacketJeiHandler> clientHandlers = new EnumMap(PacketIdClient.class);

    public PacketHandlerClient() {
        this.clientHandlers.put(PacketIdClient.CHEAT_PERMISSION, PacketCheatPermission::readPacketData);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        PacketBuffer packetBuffer = new PacketBuffer(event.getPacket().payload());
        Minecraft minecraft = Minecraft.func_71410_x();
        try {
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            IPacketJeiHandler packetHandler = this.clientHandlers.get(packetId);
            PacketHandlerClient.checkThreadAndEnqueue(packetHandler, packetBuffer, (IThreadListener)minecraft);
        }
        catch (Exception ex) {
            Log.get().error("Packet error", (Throwable)ex);
        }
    }

    private static void checkThreadAndEnqueue(IPacketJeiHandler packetHandler, PacketBuffer packetBuffer, @Nullable IThreadListener threadListener) {
        if (threadListener != null && !threadListener.func_152345_ab()) {
            packetBuffer.retain();
            threadListener.func_152344_a(() -> {
                try {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    EntityPlayerSP player = minecraft.field_71439_g;
                    if (player != null) {
                        packetHandler.readPacketData(packetBuffer, (EntityPlayer)player);
                    }
                    packetBuffer.release();
                }
                catch (IOException e) {
                    Log.get().error("Network Error", (Throwable)e);
                }
            });
        }
    }
}

