/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.oredict.OreDictionary;

public final class FuelRecipeMaker {
    private FuelRecipeMaker() {
    }

    public static List<FuelRecipe> getFuelRecipes(IIngredientRegistry ingredientRegistry, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        List<ItemStack> fuelStacks = ingredientRegistry.getFuels();
        Int2BooleanArrayMap oreIdsHaveRecipe = new Int2BooleanArrayMap();
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>(fuelStacks.size());
        for (ItemStack fuelStack : fuelStacks) {
            int burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
            List<ItemStack> subtypes = stackHelper.getSubtypes(fuelStack);
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (ItemStack subtype : subtypes) {
                if (TileEntityFurnace.func_145952_a((ItemStack)subtype) != burnTime) continue;
                fuels.add(subtype);
            }
            if (fuels.isEmpty()) {
                fuels.add(fuelStack);
            }
            if (fuels.size() <= 1) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)fuelStack);
                boolean hasOreRecipe = false;
                for (int oreId : oreIDs) {
                    if (!oreIdsHaveRecipe.containsKey(oreId)) {
                        String oreName = OreDictionary.getOreName((int)oreId);
                        List<ItemStack> ores = stackHelper.getAllSubtypes((Iterable)OreDictionary.getOres((String)oreName));
                        if (ores.size() > 1 && ores.stream().allMatch(itemStack -> TileEntityFurnace.func_145952_a((ItemStack)itemStack) == burnTime)) {
                            oreIdsHaveRecipe.put(oreId, true);
                            fuelRecipes.add(new FuelRecipe(guiHelper, ores, burnTime));
                        } else {
                            oreIdsHaveRecipe.put(oreId, false);
                        }
                    }
                    hasOreRecipe |= oreIdsHaveRecipe.get(oreId);
                }
                if (hasOreRecipe) continue;
                fuelRecipes.add(new FuelRecipe(guiHelper, fuels, burnTime));
                continue;
            }
            fuelRecipes.add(new FuelRecipe(guiHelper, fuels, burnTime));
        }
        return fuelRecipes;
    }
}

