/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.Lists;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.DarkSteelUpgradeSubtypeInterpreter;
import crazypants.enderio.base.integration.jei.ItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class DarkSteelUpgradeRecipeCategory {
    private static final List<DarkSteelRecipeManager.UpgradePath> allRecipes = DarkSteelRecipeManager.getAllRecipes(ItemHelper.getValidItems());

    public static void registerSubtypes(ISubtypeRegistry subtypeRegistry) {
        DarkSteelUpgradeSubtypeInterpreter dsusi = new DarkSteelUpgradeSubtypeInterpreter();
        HashSet<Item> items = new HashSet<Item>();
        for (ItemStack stack : ItemHelper.getValidItems()) {
            if (!(stack.func_77973_b() instanceof IDarkSteelItem)) continue;
            items.add(stack.func_77973_b());
        }
        for (Item item : items) {
            if (item == null) continue;
            subtypeRegistry.registerSubtypeInterpreter(item, (ISubtypeRegistry.ISubtypeInterpreter)dsusi);
        }
    }

    public static void register(IModRegistry registry) {
        long start = System.nanoTime();
        registry.addRecipeCatalyst((Object)new ItemStack(ModObject.blockDarkSteelAnvil.getBlockNN()), new String[]{"minecraft.anvil"});
        NNList blacklist = new NNList();
        HashSet<Item> toBlacklist = new HashSet<Item>();
        for (DarkSteelRecipeManager.UpgradePath upgradePath : allRecipes) {
            toBlacklist.add(upgradePath.getOutput().func_77973_b());
        }
        for (Item item : toBlacklist) {
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab == null) continue;
                item.func_150895_a(tab, (NonNullList)blacklist);
            }
        }
        NNList seen = new NNList();
        for (DarkSteelRecipeManager.UpgradePath rec3 : allRecipes) {
            if (DarkSteelUpgradeRecipeCategory.inList((NNList<ItemStack>)blacklist, rec3.getOutput()) || DarkSteelUpgradeRecipeCategory.inList((NNList<ItemStack>)seen, rec3.getOutput())) continue;
            seen.add((Object)rec3.getOutput());
        }
        int n = DarkSteelUpgradeRecipeCategory.registerBookEnchantmentRecipes(registry, (NNList<ItemStack>)seen);
        IVanillaRecipeFactory factory = registry.getJeiHelpers().getVanillaRecipeFactory();
        Collection anvilRecipes = (Collection)NullHelper.notnullJ(allRecipes.stream().map(rec -> factory.createAnvilRecipe(rec.getInput(), Collections.singletonList(rec.getUpgrade()), Collections.singletonList(rec.getOutput()))).collect(Collectors.toList()), (String)"Stream#collect");
        registry.addRecipes(anvilRecipes, "minecraft.anvil");
        Log.info(String.format("DarkSteelUpgradeRecipeCategory: Added %d dark steel upgrade recipes and %d enchantment recipes for upgradable items to JEI in %.3f seconds.", allRecipes.size(), n, (double)(System.nanoTime() - start) / 1.0E9));
    }

    @Nonnull
    private static CreativeTabs getCreativeTab(DarkSteelRecipeManager.UpgradePath rec) {
        return rec.getOutput().func_77973_b().func_77640_w();
    }

    private static int registerBookEnchantmentRecipes(@Nonnull IModRegistry registry, @Nonnull NNList<ItemStack> ingredients) {
        int count = 0;
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValuesCollection();
        ArrayList<IRecipeWrapper> anvilRecipes = new ArrayList<IRecipeWrapper>();
        IVanillaRecipeFactory factory = registry.getJeiHelpers().getVanillaRecipeFactory();
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.func_77956_u()) continue;
            for (Enchantment enchantment : enchantments) {
                if (!enchantment.func_92089_a(ingredient)) continue;
                Item item = ingredient.func_77973_b();
                ArrayList perLevelBooks = Lists.newArrayList();
                ArrayList perLevelOutputs = Lists.newArrayList();
                for (int level = 1; level <= enchantment.func_77325_b(); ++level) {
                    Map<Enchantment, Integer> enchMap = Collections.singletonMap(enchantment, level);
                    ItemStack bookEnchant = new ItemStack(Items.field_151134_bR);
                    EnchantmentHelper.func_82782_a(enchMap, (ItemStack)bookEnchant);
                    if (!item.isBookEnchantable(ingredient, bookEnchant)) continue;
                    perLevelBooks.add(bookEnchant);
                    ItemStack withEnchant = ingredient.func_77946_l();
                    EnchantmentHelper.func_82782_a(enchMap, (ItemStack)withEnchant);
                    perLevelOutputs.add(withEnchant);
                }
                if (perLevelBooks.isEmpty() || perLevelOutputs.isEmpty()) continue;
                anvilRecipes.add(factory.createAnvilRecipe(ingredient, (List)perLevelBooks, (List)perLevelOutputs));
                ++count;
            }
        }
        registry.addRecipes(anvilRecipes, "minecraft.anvil");
        return count;
    }

    private static boolean inList(@Nonnull NNList<ItemStack> list, @Nonnull ItemStack stack) {
        NNList.NNIterator itr = list.fastIterator();
        while (itr.hasNext()) {
            if (!ItemStack.func_77989_b((ItemStack)((ItemStack)itr.next()), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }
}

