/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.NetworkPowerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PowerConduitNetwork
extends AbstractConduitNetwork<IPowerConduit, IPowerConduit> {
    NetworkPowerManager powerManager;
    private final Map<ReceptorKey, ReceptorEntry> powerReceptors = new HashMap<ReceptorKey, ReceptorEntry>();

    public PowerConduitNetwork() {
        super(IPowerConduit.class, IPowerConduit.class);
    }

    @Override
    public void init(@Nonnull IConduitBundle tile, Collection<IPowerConduit> connections, @Nonnull World world) throws ConduitUtil.UnloadedBlockException {
        super.init(tile, connections, world);
        this.powerManager = new NetworkPowerManager(this, world);
        this.powerManager.receptorsChanged();
    }

    @Override
    public void destroyNetwork() {
        for (IPowerConduit con : this.getConduits()) {
            con.setActive(false);
        }
        if (this.powerManager != null) {
            this.powerManager.onNetworkDestroyed();
        }
        super.destroyNetwork();
    }

    public NetworkPowerManager getPowerManager() {
        return this.powerManager;
    }

    @Override
    public void addConduit(@Nonnull IPowerConduit con) {
        super.addConduit(con);
        Set externalDirs = con.getExternalConnections();
        for (EnumFacing dir : externalDirs) {
            IPowerInterface pr;
            if (dir == null || (pr = con.getExternalPowerReceptor(dir)) == null) continue;
            TileEntity te = con.getBundle().getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(dir);
            this.powerReceptorAdded(con, dir, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), pr);
        }
        if (this.powerManager != null) {
            con.setActive(this.powerManager.isActive());
        }
    }

    public void powerReceptorAdded(@Nonnull IPowerConduit powerConduit, @Nonnull EnumFacing direction, int x, int y, int z, @Nonnull IPowerInterface powerReceptor) {
        BlockPos pos = new BlockPos(x, y, z);
        ReceptorKey key = new ReceptorKey(pos, direction);
        ReceptorEntry re = this.powerReceptors.get(key);
        if (re == null) {
            re = new ReceptorEntry(powerReceptor, pos, powerConduit, direction);
            this.powerReceptors.put(key, re);
        }
        if (this.powerManager != null) {
            this.powerManager.receptorsChanged();
        }
    }

    public void powerReceptorRemoved(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        ArrayList<ReceptorKey> remove = new ArrayList<ReceptorKey>();
        for (ReceptorKey key : this.powerReceptors.keySet()) {
            if (key == null || !key.pos.equals((Object)pos)) continue;
            remove.add(key);
        }
        for (ReceptorKey key : remove) {
            this.powerReceptors.remove(key);
        }
        this.powerManager.receptorsChanged();
    }

    public Collection<ReceptorEntry> getPowerReceptors() {
        return this.powerReceptors.values();
    }

    @Override
    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        this.powerManager.applyRecievedPower(profiler);
    }

    private static class ReceptorKey {
        BlockPos pos;
        EnumFacing direction;

        ReceptorKey(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            this.pos = pos;
            this.direction = direction;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReceptorKey other = (ReceptorKey)obj;
            if (this.pos == null ? other.pos != null : !this.pos.equals((Object)other.pos)) {
                return false;
            }
            return this.direction == other.direction;
        }
    }

    public static class ReceptorEntry {
        @Nonnull
        final IPowerConduit emmiter;
        @Nonnull
        final BlockPos pos;
        @Nonnull
        final EnumFacing direction;
        IPowerInterface powerInterface;

        public ReceptorEntry(@Nonnull IPowerInterface powerReceptor, @Nonnull BlockPos pos, @Nonnull IPowerConduit emmiter, @Nonnull EnumFacing direction) {
            this.powerInterface = powerReceptor;
            this.pos = pos;
            this.emmiter = emmiter;
            this.direction = direction;
        }
    }
}

