/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.HashMap;
import lumien.randomthings.lib.IOpable;
import lumien.randomthings.lib.IRedstoneSensitive;
import lumien.randomthings.lib.ISlotFilter;
import lumien.randomthings.lib.ItemHandlerWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityBase
extends TileEntity {
    private IItemHandler inventoryHandler;
    private IItemHandler publicInventoryHandler;
    private HashMap<Integer, ISlotFilter> slotFilter;
    private Runnable inventoryChangeListener;
    private boolean itemHandlerInternal = true;
    private boolean redstonePowered;
    private boolean op;

    public boolean isOp() {
        return this.op;
    }

    protected void setItemHandler(final int slots) {
        this.inventoryHandler = new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slots);
                TileEntityBase.this.func_70296_d();
                if (TileEntityBase.this.inventoryChangeListener != null) {
                    TileEntityBase.this.inventoryChangeListener.run();
                }
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (TileEntityBase.this.slotFilter != null && TileEntityBase.this.slotFilter.containsKey(slot) && !((ISlotFilter)TileEntityBase.this.slotFilter.get(slot)).isItemStackValid(stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected void setInventoryChangeListener(Runnable runnable) {
        this.inventoryChangeListener = runnable;
    }

    protected void addSlotFilter(int slot, ISlotFilter filter) {
        if (this.slotFilter == null) {
            this.slotFilter = new HashMap();
        }
        this.slotFilter.put(slot, filter);
    }

    protected void setItemHandlerPublic(int[] insertSlots, int[] outputSlots) {
        this.itemHandlerInternal = false;
        this.publicInventoryHandler = new ItemHandlerWrapper(this.inventoryHandler, insertSlots, outputSlots);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeDataToNBT(compound, false);
        if (this.inventoryHandler instanceof ItemStackHandler) {
            NBTTagCompound inventoryCompound = ((ItemStackHandler)this.inventoryHandler).serializeNBT();
            compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
        }
        if (this instanceof IOpable) {
            compound.func_74757_a("op", this.op);
        }
        if (this instanceof IRedstoneSensitive) {
            compound.func_74757_a("redstonePowered", this.redstonePowered);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readDataFromNBT(compound, false);
        if (this.inventoryHandler instanceof ItemStackHandler) {
            ((ItemStackHandler)this.inventoryHandler).deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (this instanceof IRedstoneSensitive) {
            this.redstonePowered = compound.func_74767_n("redstonePowered");
        }
        if (this instanceof IOpable) {
            this.op = compound.func_74767_n("op");
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
        if (this.renderAfterData()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.syncAdditionalData()) {
            this.readDataFromNBT(tag, true);
        }
        if (this instanceof IRedstoneSensitive) {
            this.redstonePowered = tag.func_74767_n("redstonePowered");
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound baseCompound = super.func_189517_E_();
        if (this instanceof IRedstoneSensitive) {
            baseCompound.func_74757_a("redstonePowered", this.redstonePowered);
        }
        if (this.syncAdditionalData()) {
            this.writeDataToNBT(baseCompound, true);
        }
        return baseCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void syncTE() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
    }

    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
    }

    public boolean renderAfterData() {
        return false;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        if (this instanceof IRedstoneSensitive) {
            boolean changed;
            boolean newPowered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
            boolean bl = changed = this.redstonePowered != newPowered;
            if (changed) {
                ((IRedstoneSensitive)((Object)this)).redstoneChange(this.redstonePowered, newPowered);
                this.redstonePowered = newPowered;
                this.func_70296_d();
                this.syncTE();
            }
        }
    }

    public boolean syncAdditionalData() {
        return true;
    }

    protected boolean isPoweredByRedstone() {
        return this.redstonePowered;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.itemHandlerInternal) {
            return (T)this.publicInventoryHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.itemHandlerInternal || super.hasCapability(capability, facing);
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
    }

    public boolean isRedstonePowered() {
        return this.redstonePowered;
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public boolean toggleOp() {
        this.op = !this.op;
        return this.op;
    }
}

