/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.network.PacketHandler;
import nc.network.gui.ReturnFluidInTankPacket;
import nc.tile.fluid.ITileFluid;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class GetFluidInTankPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int tankNumber;
    String className;
    String fluidFieldName;

    public GetFluidInTankPacket() {
        this.messageValid = false;
    }

    public GetFluidInTankPacket(BlockPos pos, int tankNumber, String className, String fluidFieldName) {
        this.pos = pos;
        this.tankNumber = tankNumber;
        this.className = className;
        this.fluidFieldName = fluidFieldName;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.tankNumber = buf.readInt();
            this.className = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.fluidFieldName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tankNumber);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.className);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fluidFieldName);
    }

    public static class Handler
    implements IMessageHandler<GetFluidInTankPacket, IMessage> {
        public IMessage onMessage(GetFluidInTankPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(GetFluidInTankPacket message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (te == null) {
                return;
            }
            if (!(te instanceof ITileFluid)) {
                return;
            }
            FluidStack tankFluid = ((ITileFluid)te).getTanks().get(message.tankNumber).getFluid();
            PacketHandler.instance.sendTo((IMessage)new ReturnFluidInTankPacket(tankFluid, message.className, message.fluidFieldName), ctx.getServerHandler().field_147369_b);
        }
    }
}

