/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.handler.SoundHandler;
import nc.init.NCBlocks;
import nc.network.tile.FusionUpdatePacket;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.tile.IGui;
import nc.tile.fluid.TileActiveCooler;
import nc.tile.generator.TileFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.util.BlockFinder;
import nc.util.BlockPosHelper;
import nc.util.EnergyHelper;
import nc.util.Lang;
import nc.util.MaterialHelper;
import nc.util.RecipeHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileFusionCore
extends TileFluidGenerator
implements IGui<FusionUpdatePacket>,
SimpleComponent {
    public static final double ROOM_TEMP = 0.298;
    public double processHeatVariable = 0.0;
    public double heat = 0.298;
    public double efficiency;
    public double cooling;
    public double heatChange;
    public int currentEnergyStored = 0;
    public int energyChange = 0;
    public int soundCount;
    public int size = 1;
    public int complete;
    public String problem = RING_INCOMPLETE;
    public static final String RING_INCOMPLETE = Lang.localise("gui.container.fusion_core.ring_incomplete");
    public static final String RING_BLOCKED = Lang.localise("gui.container.fusion_core.ring_blocked");
    public static final String POWER_ISSUE = Lang.localise("gui.container.fusion_core.power_issue");
    public static final String INCORRECT_STRUCTURE = Lang.localise("gui.container.fusion_core.incorrect_structure");
    public static final String NO_PROBLEM = Lang.localise("gui.container.fusion_core.no_problem");
    public static final String NO_FUEL = Lang.localise("gui.container.fusion_core.empty");
    public boolean computerActivated = true;
    public int structureCount = 0;
    private BlockFinder finder;

    public TileFusionCore() {
        super("Fusion Core", 2, 4, 0, TileFusionCore.defaultTankCapacities(32000, 2, 4), TileFusionCore.defaultTankSorptions(2, 4), RecipeHelper.validFluids(NCRecipes.Type.FUSION), TileFusionCore.maxPower(), NCRecipes.Type.FUSION);
        this.setTanksShared(false);
    }

    private static int maxPower() {
        double max = 0.0;
        List recipes = NCRecipes.Type.FUSION.getRecipeHandler().getRecipes();
        for (ProcessorRecipe recipe : recipes) {
            if (recipe == null) continue;
            max = Math.max(max, recipe.getFusionComboPower());
        }
        return (int)Math.min(600.0 * max * NCConfig.fusion_base_power * (double)NCConfig.fusion_max_size, 2.147483647E9);
    }

    @Override
    public void onAdded() {
        this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b);
        super.onAdded();
    }

    @Override
    public void updateGenerator() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            if (this.structureCount == 0) {
                this.refreshMultiblock();
            }
            this.tickStructureCheck();
            this.energyChange = this.getEnergyStored() - this.currentEnergyStored;
            double previousHeat = this.heat;
            this.run();
            if (this.isHotEnough()) {
                this.doCooling();
            }
            this.doHeating();
            this.heatChange = 1000.0 * (this.heat - previousHeat);
            if (this.overheat()) {
                return;
            }
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (wasProcessing != this.isProcessing) {
                this.plasma();
                this.updateBlockType();
                this.sendUpdateToAllPlayers();
            }
            if (this.isHotEnough()) {
                this.pushEnergy();
            }
            this.sendUpdateToListeningPlayers();
        } else if (NCConfig.fusion_enable_sound) {
            this.playSounds();
        }
    }

    public void tickStructureCheck() {
        ++this.structureCount;
        this.structureCount %= 4 * NCConfig.machine_update_rate;
    }

    public void refreshMultiblock() {
        this.setSize();
        if (NCConfig.fusion_active_cooling) {
            this.setCooling();
        }
    }

    @Override
    public void updateBlockType() {
        super.updateBlockType();
        this.refreshMultiblock();
    }

    @Override
    public boolean isRedstonePowered() {
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        for (BlockPos pos : helper.squareRing(1, 0)) {
            if (!this.field_145850_b.func_175640_z(pos)) continue;
            return true;
        }
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean findAdjacentComparator() {
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        for (BlockPos pos : helper.cutoffRing(2, 0)) {
            if (!this.finder.find(pos, Blocks.field_150441_bU, Blocks.field_150455_bV)) continue;
            return true;
        }
        return false;
    }

    public void onFusionPacket(boolean isProcessing, double efficiency, boolean computerActivated) {
        this.isProcessing = isProcessing;
        this.efficiency = efficiency;
        this.computerActivated = computerActivated;
    }

    public boolean overheat() {
        if (this.heat >= this.getMaxHeat() && NCConfig.fusion_overheat) {
            this.meltdown();
            return true;
        }
        return false;
    }

    public void meltdown() {
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175655_b(this.field_174879_c, false);
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150353_l.func_176223_P());
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
            this.field_145850_b.func_175656_a(pos, Blocks.field_150353_l.func_176203_a(1));
        }
        for (BlockPos pos : helper.squareTube(this.ringRadius(), 1)) {
            this.field_145850_b.func_175713_t(pos);
            this.field_145850_b.func_175698_g(pos);
        }
    }

    public void playSounds() {
        if (this.soundCount >= this.getSoundTime()) {
            if (this.isProcessing) {
                if (this.ringRadius() > 1) {
                    this.playFusionSound(0, 1, 0);
                }
                this.playFusionSound(this.ringRadius(), 1, this.ringRadius());
                this.playFusionSound(this.ringRadius(), 1, -this.ringRadius());
                this.playFusionSound(-this.ringRadius(), 1, this.ringRadius());
                this.playFusionSound(-this.ringRadius(), 1, -this.ringRadius());
                if (this.ringRadius() > 5) {
                    this.playFusionSound(this.ringRadius(), 1, 0);
                    this.playFusionSound(-this.ringRadius(), 1, 0);
                    this.playFusionSound(0, 1, this.ringRadius());
                    this.playFusionSound(0, 1, -this.ringRadius());
                }
            }
            this.soundCount = 0;
        } else {
            ++this.soundCount;
        }
    }

    public void playFusionSound(int x, int y, int z) {
        this.field_145850_b.func_184134_a((double)(this.field_174879_c.func_177958_n() + x), (double)(this.field_174879_c.func_177956_o() + y), (double)(this.field_174879_c.func_177952_p() + z), this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
    }

    private int getSoundTime() {
        return !NCConfig.fusion_alternate_sound ? 67 : 67;
    }

    private SoundEvent getSound() {
        return !NCConfig.fusion_alternate_sound ? SoundHandler.fusion_run : SoundHandler.accelerator_run;
    }

    @Override
    public boolean setRecipeStats() {
        if (this.recipe == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessPower = this.defaultProcessPower;
            this.processHeatVariable = 1000.0;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipe.getFusionComboTime();
        this.baseProcessPower = this.recipe.getFusionComboPower();
        this.processHeatVariable = this.recipe.getFusionComboHeatVariable();
        this.baseProcessRadiation = this.recipe.getFusionComboRadiation();
        return true;
    }

    @Override
    public boolean isProcessing() {
        return this.readyToProcess() && !this.isDeactivated();
    }

    private boolean isDeactivated() {
        return this.isRedstonePowered() || !this.computerActivated;
    }

    @Override
    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed && this.isHotEnough() && this.complete == 1;
    }

    @Override
    public boolean canExtractEnergy(EnumFacing side) {
        return this.isHotEnough();
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return !this.isHotEnough();
    }

    public boolean isHotEnough() {
        return this.heat > 8000.0;
    }

    @Override
    public int getEUSourceTier() {
        return EnergyHelper.getEUTier(this.processPower);
    }

    @Override
    public int getEUSinkTier() {
        return 4;
    }

    public double getMaxHeat() {
        return 2.0E7;
    }

    public int ringRadius() {
        return this.size + 2;
    }

    private void setPlasma(BlockPos pos) {
        this.field_145850_b.func_175656_a(pos, FluidRegistry.getFluid((String)"plasma").getBlock().func_176223_P());
    }

    public void plasma() {
        block3: {
            BlockPosHelper helper;
            block2: {
                helper = new BlockPosHelper(this.field_174879_c);
                if (!this.isProcessing) break block2;
                for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
                    if (this.findPlasma(pos)) continue;
                    this.setPlasma(pos);
                }
                break block3;
            }
            if (this.canProcessInputs && this.isHotEnough() && (!this.isDeactivated() || this.complete != 1)) break block3;
            for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
                if (!this.findPlasma(pos)) continue;
                this.field_145850_b.func_175698_g(pos);
            }
        }
    }

    private boolean findIdleElectromagnet(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fusion_electromagnet_idle, NCBlocks.fusion_electromagnet_transparent_idle);
    }

    private boolean findActiveElectromagnet(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fusion_electromagnet_active, NCBlocks.fusion_electromagnet_transparent_active);
    }

    private boolean findElectromagnet(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fusion_electromagnet_active, NCBlocks.fusion_electromagnet_transparent_active, NCBlocks.fusion_electromagnet_idle, NCBlocks.fusion_electromagnet_transparent_idle);
    }

    private boolean findAir(BlockPos pos) {
        Material mat = this.finder.getBlockState(pos).func_185904_a();
        return MaterialHelper.isReplaceable(mat) || this.findPlasma(pos);
    }

    private boolean findPlasma(BlockPos pos) {
        return this.finder.find(pos, FluidRegistry.getFluid((String)"plasma").getBlock().func_176223_P());
    }

    private boolean findActiveCooler(BlockPos pos) {
        if (this.field_145850_b.func_175625_s(pos) == null) {
            return false;
        }
        return this.field_145850_b.func_175625_s(pos) instanceof TileActiveCooler;
    }

    public void setSize() {
        int runningSize = 1;
        for (int r = 0; r <= NCConfig.fusion_max_size && this.finder.horizontalY(this.field_174879_c.func_177972_a(EnumFacing.UP), r + 2, NCBlocks.fusion_connector); ++r) {
            ++runningSize;
        }
        this.size = runningSize;
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        for (BlockPos pos : helper.squareTube(this.ringRadius(), 1)) {
            if (this.findElectromagnet(pos)) continue;
            this.complete = 0;
            this.problem = RING_INCOMPLETE;
            return;
        }
        for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
            if (this.findAir(pos)) continue;
            this.complete = 0;
            this.problem = RING_BLOCKED;
            return;
        }
        for (BlockPos pos : helper.squareTube(this.ringRadius(), 1)) {
            if (this.findActiveElectromagnet(pos)) continue;
            this.complete = 0;
            this.problem = POWER_ISSUE;
            return;
        }
        this.complete = 1;
        this.problem = NO_PROBLEM;
    }

    public void run() {
        this.efficiency = this.efficiency();
        double heatChange = 0.0;
        if (this.isProcessing) {
            heatChange = NCConfig.fusion_heat_generation * (100.0 - 0.9 * this.efficiency) / 2.0;
            this.processPower = MathHelper.func_151237_a((double)this.efficiency, (double)0.0, (double)100.0) * NCConfig.fusion_base_power * (double)this.size * this.baseProcessPower;
            this.speedMultiplier = (double)this.size * NCConfig.fusion_fuel_use;
        } else {
            heatChange = 0.0;
            this.processPower = 0.0;
            this.speedMultiplier = 0.0;
            if (this.heat >= 0.29949) {
                this.heat -= this.heat / 100000.0 * Math.log10(1000.0 * (this.heat - 0.298));
            }
        }
        this.heat = this.heat + heatChange >= 0.298 ? (this.heat += heatChange) : 0.298;
    }

    public double efficiency() {
        if (!this.readyToProcess()) {
            return 0.0;
        }
        if (this.isHotEnough()) {
            double heatMK = this.heat / 1000.0;
            double z = 7.415 * (Math.exp(-heatMK / this.processHeatVariable) + Math.tanh(heatMK / this.processHeatVariable) - 1.0);
            return 100.0 * Math.pow(z, 2.0);
        }
        return 0.0;
    }

    public void doHeating() {
        if (!this.readyToProcess()) {
            double r = 1.0E-4 * (double)this.getEnergyStorage().getEnergyStored() / (double)this.ringRadius();
            this.getEnergyStorage().setEnergyStored(0);
            this.heat += r * NCConfig.fusion_heating_multiplier;
            this.setEnergyConnectionAll(EnergyConnection.IN);
            if (this.heat < 0.298) {
                this.heat = 0.298;
            }
        } else {
            this.setEnergyConnectionAll(EnergyConnection.OUT);
        }
    }

    public BlockPos getOpposite(BlockPos pos) {
        BlockPos relativePos = new BlockPos(pos.func_177958_n() - this.field_174879_c.func_177958_n(), pos.func_177956_o() - this.field_174879_c.func_177956_o(), pos.func_177952_p() - this.field_174879_c.func_177952_p());
        return this.finder.position(-relativePos.func_177958_n(), -relativePos.func_177956_o() + 2, -relativePos.func_177952_p());
    }

    public void setCooling() {
        if (this.complete == 1) {
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
            for (BlockPos pos : helper.squareTubeDiagonals(this.ringRadius(), 1)) {
                if (!this.findActiveCooler(pos) || ((TileActiveCooler)this.field_145850_b.func_175625_s(pos)).getTanks().get(0).getFluidAmount() <= 0) continue;
                posList.add(pos);
            }
            if (posList.isEmpty()) {
                this.cooling = 0.0;
                return;
            }
            double cooled = 0.0;
            double currentHeat = this.heat;
            for (BlockPos pos : posList) {
                Tank tank = ((TileActiveCooler)this.field_145850_b.func_175625_s(pos)).getTanks().get(0);
                int fluidAmount = Math.min(tank.getFluidAmount(), 4 * NCConfig.machine_update_rate * NCConfig.active_cooler_max_rate / 20);
                if (!(currentHeat > 0.298)) continue;
                double cool_mult = posList.contains(this.getOpposite(pos)) ? NCConfig.fusion_heat_generation * 4.0 : NCConfig.fusion_heat_generation;
                for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
                    if (tank.getFluidName() != MetaEnums.CoolerType.values()[i].getFluidName()) continue;
                    cooled += NCConfig.fusion_active_cooling_rate[i - 1] * (double)fluidAmount * cool_mult / ((double)this.size * 1000.0);
                    break;
                }
                if (!((currentHeat -= cooled) > 0.298)) continue;
                tank.drain(fluidAmount, true);
            }
            this.cooling = 1000.0 * cooled / (double)(4 * NCConfig.machine_update_rate);
        }
    }

    public void doCooling() {
        double coolingkK = this.cooling / 1000.0;
        this.heat = this.heat - coolingkK < 0.298 ? 0.298 : (this.heat -= coolingkK);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("processPower", this.processPower);
        nbt.func_74780_a("speedMultiplier", this.speedMultiplier);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74780_a("cooling", this.cooling);
        nbt.func_74780_a("heatChange", this.heatChange);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74768_a("size", this.size);
        nbt.func_74768_a("complete", this.complete);
        nbt.func_74778_a("problem", this.problem);
        nbt.func_74757_a("computerActivated", this.computerActivated);
        nbt.func_74768_a("currentEnergyStored", this.currentEnergyStored);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.processPower = nbt.func_74769_h("processPower");
        this.speedMultiplier = nbt.func_74769_h("speedMultiplier");
        this.heat = nbt.func_74769_h("heat");
        this.cooling = nbt.func_74769_h("cooling");
        this.heatChange = nbt.func_74769_h("heatChange");
        this.efficiency = nbt.func_74769_h("efficiency");
        this.size = nbt.func_74762_e("size");
        this.complete = nbt.func_74762_e("complete");
        this.problem = nbt.func_74779_i("problem");
        this.computerActivated = nbt.func_74767_n("computerActivated");
        this.currentEnergyStored = nbt.func_74762_e("currentEnergyStored");
    }

    @Override
    public int getGuiID() {
        return 101;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public FusionUpdatePacket getGuiUpdatePacket() {
        return new FusionUpdatePacket(this.field_174879_c, this.time, this.getEnergyStored(), this.baseProcessTime, this.baseProcessPower, this.isProcessing, this.heat, this.efficiency, this.speedMultiplier, this.size, this.complete, this.cooling, this.heatChange, this.hasConsumed, this.computerActivated, this.problem);
    }

    @Override
    public void onGuiPacket(FusionUpdatePacket message) {
        this.time = message.time;
        this.getEnergyStorage().setEnergyStored(message.energyStored);
        this.baseProcessTime = message.baseProcessTime;
        this.baseProcessPower = message.baseProcessPower;
        this.isProcessing = message.isProcessing;
        this.heat = message.heat;
        this.efficiency = message.efficiency;
        this.speedMultiplier = message.speedMultiplier;
        this.size = message.size;
        this.complete = message.complete;
        this.cooling = message.cooling;
        this.heatChange = message.heatChange;
        this.hasConsumed = message.hasConsumed;
        this.computerActivated = message.computerActivated;
        this.problem = message.problem;
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_fusion_reactor";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.complete == 1};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.isProcessing};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isHotEnough(Context context, Arguments args) {
        return new Object[]{this.isHotEnough()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getProblem(Context context, Arguments args) {
        return new Object[]{this.problem};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getToroidSize(Context context, Arguments args) {
        return new Object[]{this.size};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getEnergyStored()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getMaxEnergyStored()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyChange(Context context, Arguments args) {
        return new Object[]{this.energyChange};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCurrentProcessTime(Context context, Arguments args) {
        return new Object[]{this.time};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getTemperature(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxTemperature(Context context, Arguments args) {
        return new Object[]{this.getMaxHeat()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{this.efficiency};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFusionComboTime(Context context, Arguments args) {
        return new Object[]{this.recipe != null ? this.baseProcessTime : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFusionComboPower(Context context, Arguments args) {
        return new Object[]{this.baseProcessPower};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFusionComboHeatVariable(Context context, Arguments args) {
        return new Object[]{this.recipe != null ? this.processHeatVariable : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFirstFusionFuel(Context context, Arguments args) {
        return new Object[]{this.recipe != null ? this.recipe.fluidIngredients().get(0).getIngredientName() : NO_FUEL};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getSecondFusionFuel(Context context, Arguments args) {
        return new Object[]{this.recipe != null ? this.recipe.fluidIngredients().get(1).getIngredientName() : NO_FUEL};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessTime(Context context, Arguments args) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.recipe != null ? (this.size == 0 ? this.baseProcessTime : this.baseProcessTime / (double)this.size) : 0.0;
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessPower(Context context, Arguments args) {
        return new Object[]{this.processPower};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessHeat(Context context, Arguments args) {
        return new Object[]{this.heatChange};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorCoolingRate(Context context, Arguments args) {
        return new Object[]{this.cooling};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        this.computerActivated = true;
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        this.computerActivated = false;
        return new Object[0];
    }
}

