/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.data.SimpleContent;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

class ToolTip
extends SimpleContent {
    private static final String MODE_ALL = "all";
    private static final String MODE_CTRL = "ctrl";
    private static final String MODE_SHIFT = "shift";
    private static final String MODE_ALT = "alt";
    private static final String MODE_NO_CTRL = "noctrl";
    private static final String MODE_NO_SHIFT = "noshift";
    private static final String MODE_NO_ALT = "noalt";
    WrappedItemStack item;
    String[] text;
    String mode = "all";
    boolean clearExisting = false;
    private transient ItemStack stack;

    ToolTip() {
    }

    @Override
    protected void doInit(InitPhase phase, ContentHelper helper) {
        this.stack = this.item.getItemStack();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    void onToolTip(ItemTooltipEvent event) {
        if (this.isCorrectModeActive() && this.isCorrectItem(event.getItemStack())) {
            List toolTip = event.getToolTip();
            this.modifyToolTip(toolTip);
        }
    }

    void modifyToolTip(List<String> toolTip) {
        if (this.clearExisting) {
            toolTip.clear();
        }
        Collections.addAll(toolTip, this.text);
    }

    private boolean isCorrectItem(ItemStack eventStack) {
        boolean itemEqual = eventStack.func_77960_j() == Short.MAX_VALUE ? this.stack.func_185136_b(eventStack) : this.stack.func_77969_a(eventStack);
        boolean nbtEqual = !eventStack.func_77942_o() || ItemStack.func_77970_a((ItemStack)eventStack, (ItemStack)this.stack);
        return itemEqual && nbtEqual;
    }

    private boolean isCorrectModeActive() {
        switch (this.mode.toLowerCase()) {
            case "shift": {
                return GuiScreen.func_146272_n();
            }
            case "ctrl": {
                return GuiScreen.func_146271_m();
            }
            case "alt": {
                return GuiScreen.func_175283_s();
            }
            case "noshift": {
                return !GuiScreen.func_146272_n();
            }
            case "noctrl": {
                return !GuiScreen.func_146271_m();
            }
            case "noalt": {
                return !GuiScreen.func_175283_s();
            }
        }
        return true;
    }

    @Override
    protected boolean isReady() {
        return this.item.isItemLoaded();
    }
}

