/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import cubex2.cs4.plugins.vanilla.ContentBlockOrientable;
import cubex2.cs4.plugins.vanilla.block.BlockSimple;
import cubex2.cs4.util.BlockHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public abstract class BlockOrientable
extends BlockSimple {
    protected final ContentBlockOrientable content;

    public BlockOrientable(Material material, ContentBlockOrientable content) {
        super(material, content);
        this.content = content;
    }

    @Override
    public IProperty<?>[] getProperties() {
        return new IProperty[]{this.getFacingProperty()};
    }

    protected abstract PropertyDirection getFacingProperty();

    @Override
    public int getSubtype(IBlockState state) {
        return 0;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)this.getFacingProperty(), (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)this.getFacingProperty())));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)this.getFacingProperty())));
    }

    protected final EnumFacing getVerticalFacingForPlacement(BlockPos pos, EnumFacing facing, int meta, EntityLivingBase placer) {
        if (this.content.faceBySide.get(meta).orElse(false).booleanValue() && facing.func_176740_k().func_176720_b()) {
            return facing;
        }
        return BlockHelper.getVerticalFacingFromEntity(pos, placer);
    }

    protected final EnumFacing getHorizontalFacingForPlacement(BlockPos pos, EnumFacing facing, int meta, EntityLivingBase placer) {
        if (this.content.faceBySide.get(meta).orElse(false).booleanValue() && facing.func_176740_k().func_176722_c()) {
            return facing;
        }
        return placer.func_174811_aO().func_176734_d();
    }

    protected final EnumFacing getDirectionalFacingForPlacement(BlockPos pos, EnumFacing facing, int meta, EntityLivingBase placer) {
        if (this.content.faceBySide.get(meta).orElse(false).booleanValue()) {
            return facing;
        }
        return EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
    }
}

